<?php

/*------------------------------------------------------------------------
# mod_redshop_magicthumb - Magic Thumb for Joomla with redSHOP
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicthumb/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla controller library
jimport('joomla.application.component.controller');

if(!defined('MAGICTOOLBOX_LEGACY_CONTROLLER_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_CONTROLLER_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyController extends JControllerLegacy {}
    } else {
        class MagicToolboxLegacyController extends JController {}
    }
}

class Redshop_MagicthumbController extends MagicToolboxLegacyController {

    public function display($cachable = false, $urlparams = false) {
        JRequest::setVar('view', JRequest::getCmd('view', 'default'));
        parent::display($cachable, $urlparams);
        return $this;
    }

    public function displayConfig($cachable = false, $urlparams = false) {
        JRequest::setVar('view', 'default');
        parent::display($cachable, $urlparams);
        return $this;
    }

    public function install() {

        //NOTE: to fix URL's in css files
        $this->fixCSS();

        jimport('joomla.installer.installer');

        $installer = new JInstaller();//JInstaller::getInstance();
        $installer->setOverwrite(true);

        $packagDir = dirname(__FILE__).DS.'redshop_module';

        if(!JVERSION_16) {
            //NOTE: it is important, that XML file name matches module name. Otherwise, Joomla wouldn't show parameters and additional info stored in XML.
            copy($packagDir.DS.'mod_redshop_magicthumb_j15.xml', $packagDir.DS.'mod_redshop_magicthumb.xml');
        }

        $message = '';

        if($installer->install($packagDir)) {

            $database = JFactory::getDBO();

            //NOTE: update 'Details'
            $title = JText::_('COM_REDSHOP_MAGICTHUMB_MODULE_TITLE');
            $position = JVERSION_16 ? 'position-7' : 'left';//position-3
            $database->setQuery("UPDATE `#__modules` SET `title`='{$title}', `ordering`=0, `position`='{$position}', `published`=1, `showtitle`=0 WHERE `module`='mod_redshop_magicthumb'");
            if(!$database->query()) {
                $message = JText::_($database->getErrorMsg());
            }

            //NOTE: update 'Menu Assignment'
            $database->setQuery("INSERT IGNORE INTO `#__modules_menu` (`moduleid`, `menuid`) SELECT `m`.`id`, 0 FROM `#__modules`  AS `m` WHERE `m`.`module`='mod_redshop_magicthumb'");
            if(!$database->query()) {
                $message = JText::_($database->getErrorMsg());
            }

        } else {
            $message = JText::_('COM_REDSHOP_MAGICTHUMB_INSTALL_ERROR');
        }

        if(empty($message)) {
            $this->setMessage(JText::_('COM_REDSHOP_MAGICTHUMB_INSTALL_SUCCESS'), 'message');
        } else {
            $this->setMessage($message, 'error');
        }


        $this->setRedirect(JRoute::_('index.php?option=com_redshop_magicthumb', false));

        return $this;
    }

    public function fixCSS() {

        //NOTE: to fix URL's in css files

        $path = dirname(__FILE__).DS.'redshop_module'.DS.'media';

        $list = glob($path.'/*');
        $files = array();
        if(is_array($list)) {
            for($i = 0; $i < count($list); $i++) {
                if(is_dir($list[$i])) {
                    if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                        $add = glob($list[$i].'/*');
                        if(is_array($add)) {
                            $list = array_merge($list, $add);
                        }
                    }
                } else if(preg_match('#\.css$#i', $list[$i])) {
                    $files[] = $list[$i];
                }
            }
        }

        foreach($files as $file) {
            if(!is_writable($file)) {
                continue;
            }
            $cssPath = dirname($file);
            $cssRelPath = str_replace($path, '', $cssPath);
            $toolPath = JURI::root(true).'/media/mod_redshop_magicthumb'.$cssRelPath;
            $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
            $replace = 'url($1'.$toolPath.'/$2$1)';
            $fileContents = file_get_contents($file);
            $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
            //preg_match_all($pattern, $fileContents, $matches, PREG_SET_ORDER);
            //debug_log($matches);
            if($fixedFileContents != $fileContents) {
                $fp = fopen($file, 'w+');
                if($fp) {
                    fwrite($fp, $fixedFileContents);
                    fclose($fp);
                }
            }
        }

    }

    public function apply() {
        $this->saveParamsToDB();
        $this->setMessage(JText::_('COM_REDSHOP_MAGICTHUMB_SAVE_TEXT'), 'message');
        $profile = JRequest::getVar('profile', false, 'post');
        $profile = ($profile ? '&profile='.$profile : '');
        $this->setRedirect(JRoute::_('index.php?option=com_redshop_magicthumb'.$profile, false));
        return $this;
    }

    public function save() {
        $this->saveParamsToDB();
        $this->setMessage(JText::_('COM_REDSHOP_MAGICTHUMB_SAVE_TEXT'), 'message');
        $this->setRedirect(JRoute::_('index.php?option=com_redshop_magicthumb', false));
        return $this;
    }

    public function cancel() {
        //$view = JRequest::getVar('view', false, 'post');
        $profile = JRequest::getVar('profile', false, 'post');
        //$target = JRequest::getVar('target', false, 'post');
        if($profile) {
            $this->setRedirect(JRoute::_('index.php?option=com_redshop_magicthumb', false));
        } else {
            $this->setRedirect(JRoute::_('index.php', false));
        }
        return $this;
    }

    public function saveParamsToDB() {
        $post = JRequest::get('post');
        $database = JFactory::getDBO();
        $profile = JRequest::getVar('profile', false, 'post');
        if(!empty($post) && !empty($post['config']) && is_array($post['config']) && !empty($profile)) {
            //require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_magicthumb'.DS.'redshop_module'.DS.'site'.DS.'classes'.DS.'magicthumb.module.core.class.php');
            //$tool = new MagicThumbModuleCoreClass();
            $cases = array();
            $names = array();
            foreach($post['config'] as $name => $value) {
                    //$database->setQuery("UPDATE `#__redshop_magicthumb_config` SET `value`='{$value}', `disabled`='0' WHERE profile='{$profile}' AND name='{$name}'");
                    //$database->query();
                    $cases[] = "WHEN '{$name}' THEN '{$value}'";
                    $names[] = "'{$name}'";
            }
            $database->setQuery("UPDATE `#__redshop_magicthumb_config` SET `value` = CASE `name` ".implode(' ', $cases)." END WHERE `name` IN (".implode(', ', $names).") AND profile='{$profile}'");
            $database->query();
        }
    }

}
