<?php

/*------------------------------------------------------------------------
# com_magiczoomplus - Magic Zoom Plus for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoomplus/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla view library
jimport('joomla.application.component.view');

if(!defined('MAGICTOOLBOX_LEGACY_VIEW_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_VIEW_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyView extends JViewLegacy {}
    } else {
        class MagicToolboxLegacyView extends JView {}
    }
}

class MagiczoomplusViewDefault extends MagicToolboxLegacyView {

    function display($tpl = null) {

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $app->input->set('hidemainmenu' , true );
        } else {
            JRequest::setVar('hidemainmenu', true);
        }

        $document = JFactory::getDocument();

        $document->addStyleSheet(JURI::root().'media/com_magiczoomplus/backend.css');

        JToolBarHelper::title(JText::_('COM_MAGICZOOMPLUS_MANAGER_SETTINGS'), 'magiczoomplus.png');
        JToolBarHelper::save('save');//Save & Close
        JToolBarHelper::apply('apply');//Save
        JToolBarHelper::cancel('cancel', 'Close');//Close

        $classesFolded = JVERSION_16 ? 'magiczoomplus'.DS.'magiczoomplus_classes' : 'magiczoomplus_classes';
        require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.$classesFolded.DS.'magiczoomplus.module.core.class.php');
        $this->tool = new MagicZoomPlusModuleCoreClass();
        $database = JFactory::getDBO();
        $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__magiczoomplus_config` WHERE `disabled`='0'");
        $results = $database->loadAssocList();
        if(!empty($results)) {
            foreach($results as $row) {
                $this->tool->params->setValue($row['name'], $row['value'], $row['profile']);
            }
        }

        //NOTE: change subtype for some params to display them like radio
        foreach($this->tool->params->getParams() as $paramId => $param) {
           if($this->tool->params->getSubType($paramId) == 'select' && count($this->tool->params->getValues($paramId)) < 6)
               $this->tool->params->setSubType($paramId, 'radio');
        }

        //$this->tab = JRequest::getVar('tab', 'default', 'get');
        $this->tab = JFactory::getApplication()->input->get('tab', 'default', 'get');

        $this->profiles = array('default' => 'General');
        $this->imageUrl = JURI::root().'media/com_magiczoomplus/images/';
        $this->paramsMap = array(
			'default' => array(
				'General' => array(
					'enable-effect',
				),
				'Positioning and Geometry' => array(
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
				),
				'Multiple images' => array(
					'selectorTrigger',
					'transitionEffect',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile',
				),
			),
		);


        parent::display($tpl);

    }

}
