<?php

/*------------------------------------------------------------------------
# com_magiczoom - Magic Zoom for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoom/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagiczoomForJoomla();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagiczoomForJoomla();
    }
}

function installMagiczoomForJoomla() {

    $database = JFactory::getDBO();
    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__magiczoom_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count) {
        $database->setQuery("DROP TABLE IF EXISTS `#__magiczoom_config_bak`;");
        $database->execute();
        $database->setQuery("RENAME TABLE `#__magiczoom_config` TO `#__magiczoom_config_bak`;");
        if($database->execute()) {
            $database->setQuery("CREATE TABLE `#__magiczoom_config` LIKE `#__magiczoom_config_bak`;");
            if($database->execute()) {
                $results->count = 0;
            }
        }
    }
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__magiczoom_config` (`profile`, `name`, `value`, `default`, `disabled`) VALUES
 ('default', 'zoomWidth', 'auto', 'auto', '0'),
 ('default', 'zoomHeight', 'auto', 'auto', '0'),
 ('default', 'zoomPosition', 'right', 'right', '0'),
 ('default', 'zoomDistance', '15', '15', '0'),
 ('default', 'selectorTrigger', 'click', 'click', '0'),
 ('default', 'transitionEffect', 'Yes', 'Yes', '0'),
 ('default', 'lazyZoom', 'No', 'No', '0'),
 ('default', 'rightClick', 'No', 'No', '0'),
 ('default', 'cssClass', '', '', '0'),
 ('default', 'show-message', 'No', 'No', '0'),
 ('default', 'message', 'Move your mouse over image', 'Move your mouse over image', '0'),
 ('default', 'zoomMode', 'zoom', 'zoom', '0'),
 ('default', 'zoomOn', 'hover', 'hover', '0'),
 ('default', 'upscale', 'Yes', 'Yes', '0'),
 ('default', 'smoothing', 'Yes', 'Yes', '0'),
 ('default', 'variableZoom', 'No', 'No', '0'),
 ('default', 'zoomCaption', 'off', 'off', '0'),
 ('default', 'hint', 'once', 'once', '0'),
 ('default', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom', '0'),
 ('default', 'textClickZoomHint', 'Click to zoom', 'Click to zoom', '0'),
 ('default', 'zoomModeForMobile', 'off', 'off', '0'),
 ('default', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom', '0'),
 ('default', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom', '0'),
 ('default', 'version', '3.4.3', '3.4.3', '0');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_magiczoom&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The plugin will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendJoomlaMagiczoomModuleStat('install');
    return true;
}

function uninstallMagiczoomForJoomla() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_magiczoom', JPATH_ADMINISTRATOR, null, false);
    }

    $database = JFactory::getDBO();

    //NOTE: uninstall plugin
    if(version_compare(JVERSION, '1.6.0', '<')) {
        $query = "DELETE FROM `#__plugins` WHERE element='magiczoom'";
    } else {
        $query = "DELETE FROM `#__extensions` WHERE element='magiczoom'";
    }
    $database->setQuery($query);
    $database->execute();

    //$manifest = file_exists(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom'.DS.'magiczoom.xml') ? simplexml_load_file(JPATH_SITE.DS.'pugins'.DS.'system'.DS.'magiczoom'.DS.'magiczoom.xml') : false;//SimpleXMLElement
    //if($manifest) {
    //}
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magiczoom.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magiczoom.ini');
    }
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magiczoom.sys.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magiczoom.sys.ini');
    }
    if(is_dir(JPATH_SITE.DS.'media'.DS.'plg_system_magiczoom')) {
        JFolder::delete(JPATH_SITE.DS.'media'.DS.'plg_system_magiczoom');
    }
    if(version_compare(JVERSION, '1.6.0', '<')) {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom_classes')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom_classes');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom.php')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom.php');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom.xml')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom.xml');
        }
    } else {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magiczoom');
        }
    }


    //if(is_dir(JPATH_SITE.DS.'media'.DS.'com_magiczoom')) {
    //    JFolder::delete(JPATH_SITE.DS.'media'.DS.'com_magiczoom');
    //}

    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_MAGICZOOM_UNINSTALL_TEXT').'</p>
          </div>';

    sendJoomlaMagiczoomModuleStat('uninstall');
    return true;

}

class com_magiczoomInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagiczoomForJoomla();
    }

    function update($parent) {
        return installMagiczoomForJoomla();
    }

    function uninstall($parent) {
        return uninstallMagiczoomForJoomla();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendJoomlaMagiczoomModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v3.4.3' || 'working' == 'v5.3.7') {
        return;
    }

    /* 

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    if(class_exists('joomlaVersion')) {
        //old joomla, 1.0.x
        $versionObj = new joomlaVersion();
    } elseif(class_exists('JVersion')) {
        $versionObj = new JVersion();
    } else {
        return;
    }

    $platformVersion = $versionObj->getShortVersion();

    $path = "api/stat/?action={$action}&tool_name=magiczoom&license=trial&tool_version=v5.3.7&module_version=v3.4.3&platform_name=joomla&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

    */

}
