<?php

/*------------------------------------------------------------------------
# plg_system_magiczoom - Magic Zoom for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoom/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

global $displayMagicZoomForJoomlaHeaders;

if(!defined('MAGICZOOM_FOR_JOOMLA_INIT')) {
    define('MAGICZOOM_FOR_JOOMLA_INIT', true);
    defined('DS') or define('DS', DIRECTORY_SEPARATOR);
    defined('JVERSION_16') or define('JVERSION_16', version_compare(JVERSION, '1.6.0','>=') ? true : false);
    defined('JVERSION_30') or define('JVERSION_30', version_compare(JVERSION, '3.0.0','>=') ? true : false);
    $displayMagicZoomForJoomlaHeaders = false;
}

if(!defined('MAGICTOOLBOX_JURI_BASE')) {
    $url = JURI::base(true);
    //NOTE: JURI::base() return URI according to $live_site variable in configuration
    //      this leads to problem with wrong protocol prefix (http/https)
    //      so this is a fix
    if(empty($_SERVER['HTTPS']) || (strtolower($_SERVER['HTTPS']) == 'off')) {
        $url = preg_replace('/^https:/i', 'http:', $url);
    } else {
        $url = preg_replace('/^http:/i', 'https:', $url);
    }
    define('MAGICTOOLBOX_JURI_BASE', $url);
}

class PlgSystemMagicZoom extends JPlugin {

    protected static $instance = null;

    public function __construct(&$subject, $config = array()) {
        parent::__construct($subject, $config);
        if(is_null(self::$instance)) {
            self::$instance = $this;
        }
        //$this->loadLanguage();
    }

    public static function getInstance() {
        if(is_null(self::$instance)) {
            self::$instance = new PlgSystemMagicZoom(JEventDispatcher::getInstance(), JPluginHelper::getPlugin('system', 'magiczoom'));
        }
        return self::$instance;
    }

    public function onAfterRender() {

		$app = JFactory::getApplication();
		if($app->isClient('administrator')) return;

        global $displayMagicZoomForJoomlaHeaders;

        $tool = $this->getToolMagicZoomForJoomla();

        if (JVERSION>'4.0') {            
            $contents = JFactory::getApplication()->getBody();
        } else {
            $contents = JResponse::getBody();
        }

        if(!$tool->params->checkValue('enable-effect', 'No', 'default')) {

            $tool->params->setProfile('default');


            //NOTE: old pattern
            //'<a\b([^>]*?\bclass=["\'][^"\']*?\bMagicZoom\b[^"\']*+["\'][^>]*+)>(.*?)</a>'
            $pattern =  str_replace('MagicZoomPlus','MagicZoom(?:Plus)?','(?:<p[^>]*+>[^<]*+)?<a\b([^>]*?\bclass=["\'][^"\']*?\bMagicZoom\b[^"\']*+["\'][^>]*+)>').
                        '('.
                        '(?:'.
                            '[^<]++'.
                            '|'.
                            '<(?!/?a\b|!--)'.
                            '|'.
                            '<!--.*?-->'.
                            '|'.
                            '<a\b[^>]*+>'.
                                '(?2)'.
                            '</a\s*+>'.
                        ')*+'.
                        ')'.
                        '</a\s*+>(?:[^<]*+</p\s*+>)?';

            //$contents = preg_replace_callback("#{$pattern}#is", 'callbackMagicZoomForJoomla', $contents);
            $contents = preg_replace_callback("#{$pattern}#is", array('PlgSystemMagicZoom', 'callbackMagicZoomForJoomla'), $contents);
            //preg_match_all('%'.$pattern.'%is', $contents, $__matches, PREG_SET_ORDER);

            //NOTE: to fix relative URLs (rev/data-image/... etc tags) (like SEF plugin)
            $pattern = '<a\b[^>]*?\b(?:data-)?zoom-id\b[^>]*+>';

            $contents = preg_replace_callback("#{$pattern}#is", array('PlgSystemMagicZoom', 'callbackMagicZoomForJoomlaFixURL'), $contents);

        }
        else return true;

        if(!$displayMagicZoomForJoomlaHeaders || defined('MagicZoom_HEADERS_LOADED')) return true;

        define('MagicZoom_HEADERS_LOADED', true);

        $tool->params->resetProfile();
        $url = MAGICTOOLBOX_JURI_BASE.'/media/plg_system_magiczoom';
        $headers = array();
        $headers[] = "\n".$tool->getHeadersTemplate($url);
        $headers[] = "\n<link type=\"text/css\" href=\"{$url}/magictoolbox.css\" rel=\"stylesheet\" media=\"screen\" />\n";
        $contents = preg_replace('#(<!-- Magic Slideshow Joomla module|</head>)#is', implode($headers).'$1', $contents, 1);

       if (JVERSION>'4.0') {            
            JFactory::getApplication()->setBody($contents);
        } else {
            JResponse::setBody($contents);
        }

        return true;
    }

    public function getToolMagicZoomForJoomla() {
        static $mainCoreClass = null;
        if($mainCoreClass === null) {
            require_once(dirname(__FILE__).DS.'magiczoom_classes'.DS.'magiczoom.module.core.class.php');
            $mainCoreClass = new MagicZoomModuleCoreClass();
            $database = JFactory::getDBO();
            $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__magiczoom_config` WHERE `disabled`='0'");
            $results = $database->loadAssocList();
            if(!empty($results)) {
                foreach($results as $row) {
                    $mainCoreClass->params->setValue($row['name'], $row['value'], $row['profile']);
                }
            }
        }
        return $mainCoreClass;
    }

    public function callbackMagicZoomForJoomla($_matches) {

        $original = &$_matches[0];
        $attributes = &$_matches[1];
        $innerHTML = &$_matches[2];

        $matches = array();

        $id = '';
        if(preg_match('#\bid\s*+=\s*+["\']([^"\']*+)["\']#is', $attributes, $matches)) {
            $id = $matches[1];
        }

        if(preg_match('/MagicZoomImage/is', $id)) return $original;

        $img = '';
        if(preg_match('#\bhref\s*+=\s*+["\']([^"\']*+)["\']#is', $attributes, $matches)) {
            $img = $matches[1];
        }

        $link = '';
        if(preg_match('#\btarget\s*+=\s*+["\']([^"\']*+)["\']#is', $attributes, $matches)) {
            $link = $matches[1];
        }

        $thumb = '';
        if(preg_match('#\bsrc\s*+=\s*+["\']([^"\']*+)["\']#is', $innerHTML, $matches)) {
            $thumb = $matches[1];
        }

        $alt = '';
        if(preg_match('#\balt\s*+=\s*+(["\'])(.*?)\1#is', $innerHTML, $matches)) {
            $alt = $matches[2];
        }

        $title = '';
        if(preg_match('#\btitle\s*+=\s*+(["\'])(.*?)\1#is', $innerHTML, $matches)) {
            $title = $matches[2];
        }

        $aTitle = '';
        if(preg_match('#\btitle\s*+=\s*+(["\'])(.*?)\1#is', $attributes, $matches)) {
            $aTitle = $matches[2];
        }

        $spanTitle = '';
        //"#<span>(.*)</span>(?!.*?</span>.*?)#is"
        if(preg_match(  '#<span\b[^>]*+>'.
                        '('.
                        '(?:'.
                            '[^<]++'.
                            '|'.
                            '<(?!/?span\b|!--)'.
                            '|'.
                            '<!--.*?-->'.
                            '|'.
                            '<span\b[^>]*+>'.
                                '(?1)'.
                            '</span\s*+>'.
                        ')*+'.
                        ')'.
                        '</span\s*+>#is', $innerHTML, $matches)) {
            $spanTitle = $matches[1];
        }

        $caption = '';
        $mosimage = false;
        if($alt == $title && $alt == 'Image') {
            $mosimage = true;
            $alt = $title = '';
        }
        if(preg_match('#mosimage#is', $innerHTML)) {
            $mosimage = true;
            if(preg_match(  '#<div\b[^>]*?\bclass\s*+=\s*+["\'][^"\']*?\bmosimage_caption\b[^"\']*+["\'][^>]*+>'.
                            '('.
                            '(?:'.
                                '[^<]++'.
                                '|'.
                                '<(?!/?div\b|!--)'.
                                '|'.
                                '<!--.*?-->'.
                                '|'.
                                '<div\b[^>]*+>'.
                                    '(?1)'.
                                '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>#is', $innerHTML, $matches)) {
                $caption = $matches[1];
            }
        }

        $width = '';
        if(preg_match('#\bwidth\s*+=\s*+["\']([^"\']*+)["\']#is', $innerHTML, $matches)) {
            $width = $matches[1];
        }

        $height = '';
        if(preg_match('#\bheight\s*+=\s*+["\']([^"\']*+)["\']#is', $innerHTML, $matches)) {
            $height = $matches[1];
        }

        $align = '';
        if(preg_match('#\balign\s*+=\s*+["\']([^"\']*+)["\']#is', $innerHTML, $matches)) {
            $align = $matches[1];
        }
        if(empty($align)) {
            if(preg_match('#float\s*+:\s*+(left|right)\s*+[;"\']#is', $innerHTML, $matches)) {
                $align = $matches[1];
            }
        }

        $title = empty($caption) ? (empty($spanTitle) ? (empty($alt) ? (empty($title) ? $aTitle : $title) : $alt) : $spanTitle) : $caption;

        if(!empty($title)) {
            $title = html_entity_decode($title);
            $title = str_replace('mce_thref', 'href', $title);
        }

        $tool = $this->getToolMagicZoomForJoomla();

        //NOTE: we don't need all options in rel
        $tool->params->setProfile('temp');

        $html = $tool->getMainTemplate(compact('img', 'thumb', 'id', 'title', 'width', 'height', 'link'));

        //NOTE: reset profile to default
        $tool->params->resetProfile();

        if(!empty($id)) $html = preg_replace('#(<a\b[^>]*?id\s*+=\s*+["\'])MagicZoomImage#s', '$1', $html);

        if(preg_match('#\b(?:rel|data-options)\s*+=\s*+["\']([^"\']*+)["\']#is', $attributes, $matches)) {
            $customOptionsAttribute = $matches[0];
            $customOptions = $matches[1];
            if(preg_match('#\b(?:rel|data-options)\s*+=\s*+["\']([^"\']*+)["\']#is', $html, $matches)) {
                $magictoolboxOptions = explode(';', $matches[1]);
                $magictoolboxOptionsLength = count($magictoolboxOptions);
                for($i = 0; $i < $magictoolboxOptionsLength; $i++) {
                    $optionLine = trim($magictoolboxOptions[$i]);
                    unset($magictoolboxOptions[$i]);
                    if(empty($optionLine)) continue;
                    list($key, $value) = explode(':', $optionLine);
                    if(!empty($value)) $magictoolboxOptions[trim($key)] = $value;
                }
                $customOptions = explode(';', $customOptions);
                foreach($customOptions as $optionLine) {
                    $optionLine = trim($optionLine);
                    if(empty($optionLine)) continue;
                    list($key, $value) = explode(':', $optionLine);
                    if(!empty($value)) $magictoolboxOptions[trim($key)] = $value;
                }
                $customOptions = array();
                foreach($magictoolboxOptions as $key => $value) {
                    $customOptions[] = "{$key}:{$value}";
                }
                $customOptions = implode(';', $customOptions).';';
                $html = preg_replace('#^(.*?\b(?:rel|data-options)\s*+=\s*+["\'])[^"\']*+(["\'].*+)$#is', "$1{$customOptions}$2", $html);
            } else {
                $html = preg_replace('#<a\b[^>]*?class=["\'][^"\']*?\bMagicZoom\b[^"\']*+["\'][^>]*+#is', "$0 {$customOptionsAttribute} ", $html);
            }
        }

        /*
        $html = preg_replace("/^(<a.*?<\/a>).*$/iUs", "$1", $html);
        $message = trim($tool->params->getValue('message'));
        if(!empty($message) && $tool->params->checkValue('show-message', 'Yes')) {
            $html = $html.'<br />'.$message;
        }
        */

        $float = empty($align) ? '' : "float: {$align};";
        //$html = "<b style=\"display: block; font-weight: normal; {$float}; margin: 0 3px 0 0; text-align: center;\">{$html}</b>";
        $html = '<div class="MagicToolboxContainer" style="'.$float.'">'.$html.'</div>';

        global $displayMagicZoomForJoomlaHeaders;
        $displayMagicZoomForJoomlaHeaders = true;

        return $html;
    }

    public function callbackMagicZoomForJoomlaFixURL($_matches) {
        $protocols = '[a-zA-Z0-9\-]+:';
        $pattern = '\b(?:rev|data-image)\s*+=\s*+["\'](?!/|'.$protocols.')([^"\']*+)["\']';
        if(preg_match('#'.$pattern.'#is', $_matches[0], $match)) {
            $attribute = str_replace($match[1], MAGICTOOLBOX_JURI_BASE.'/'.$match[1], $match[0]);
            $_matches[0] = str_replace($match[0], $attribute, $_matches[0]);
        }

        return $_matches[0];

    }

}
