<?php

/*------------------------------------------------------------------------
# com_magicthumb - Magic Thumb for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicthumb/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagicthumbForJoomla();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagicthumbForJoomla();
    }
}

function installMagicthumbForJoomla() {

    $database = JFactory::getDBO();
    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__magicthumb_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count) {
        $database->setQuery("DROP TABLE IF EXISTS `#__magicthumb_config_bak`;");
        $database->execute();
        $database->setQuery("RENAME TABLE `#__magicthumb_config` TO `#__magicthumb_config_bak`;");
        if($database->execute()) {
            $database->setQuery("CREATE TABLE `#__magicthumb_config` LIKE `#__magicthumb_config_bak`;");
            if($database->execute()) {
                $results->count = 0;
            }
        }
    }
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__magicthumb_config` (`profile`, `name`, `value`, `default`, `disabled`) VALUES
 ('default', 'expandEffect', 'expand', 'expand', '0'),
 ('default', 'expandSpeed', '350', '350', '0'),
 ('default', 'expandImageSize', 'fit-screen', 'fit-screen', '0'),
 ('default', 'expandTrigger', 'click', 'click', '0'),
 ('default', 'expandAlign', 'screen', 'screen', '0'),
 ('default', 'expandEasing', 'ease-in-out', 'ease-in-out', '0'),
 ('default', 'gallerySpeed', '250', '250', '0'),
 ('default', 'loop', 'Yes', 'Yes', '0'),
 ('default', 'selectorTrigger', 'click', 'click', '0'),
 ('default', 'selectorEffect', 'switch', 'switch', '0'),
 ('default', 'show-caption', 'Yes', 'Yes', '0'),
 ('default', 'captionPosition', 'bottom', 'bottom', '0'),
 ('default', 'link', '', '', '0'),
 ('default', 'linkTarget', '_self', '_self', '0'),
 ('default', 'keyboard', 'Yes', 'Yes', '0'),
 ('default', 'cssClass', '', '', '0'),
 ('default', 'rightClick', 'Yes', 'Yes', '0'),
 ('default', 'lazyLoad', 'No', 'No', '0'),
 ('default', 'autostart', 'Yes', 'Yes', '0'),
 ('default', 'buttons', 'auto', 'auto', '0'),
 ('default', 'textBtnClose', 'Close', 'Close', '0'),
 ('default', 'textBtnNext', 'Next', 'Next', '0'),
 ('default', 'textBtnPrev', 'Previous', 'Previous', '0'),
 ('default', 'hint', 'once', 'once', '0'),
 ('default', 'textClickHint', 'Click to expand', 'Click to expand', '0'),
 ('default', 'textHoverHint', 'Hover to expand', 'Hover to expand', '0'),
 ('default', 'slideMobileEffect', 'rotate', 'rotate', '0'),
 ('default', 'textClickHintForMobile', 'Tap to expand', 'Tap to expand', '0'),
 ('default', 'version', '3.4.3', '3.4.3', '0');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_magicthumb&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The plugin will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendJoomlaMagicthumbModuleStat('install');
    return true;
}

function uninstallMagicthumbForJoomla() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_magicthumb', JPATH_ADMINISTRATOR, null, false);
    }

    $database = JFactory::getDBO();

    //NOTE: uninstall plugin
    if(version_compare(JVERSION, '1.6.0', '<')) {
        $query = "DELETE FROM `#__plugins` WHERE element='magicthumb'";
    } else {
        $query = "DELETE FROM `#__extensions` WHERE element='magicthumb'";
    }
    $database->setQuery($query);
    $database->execute();

    //$manifest = file_exists(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb'.DS.'magicthumb.xml') ? simplexml_load_file(JPATH_SITE.DS.'pugins'.DS.'system'.DS.'magicthumb'.DS.'magicthumb.xml') : false;//SimpleXMLElement
    //if($manifest) {
    //}
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magicthumb.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magicthumb.ini');
    }
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magicthumb.sys.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magicthumb.sys.ini');
    }
    if(is_dir(JPATH_SITE.DS.'media'.DS.'plg_system_magicthumb')) {
        JFolder::delete(JPATH_SITE.DS.'media'.DS.'plg_system_magicthumb');
    }
    if(version_compare(JVERSION, '1.6.0', '<')) {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb_classes')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb_classes');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb.php')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb.php');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb.xml')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb.xml');
        }
    } else {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magicthumb');
        }
    }


    //if(is_dir(JPATH_SITE.DS.'media'.DS.'com_magicthumb')) {
    //    JFolder::delete(JPATH_SITE.DS.'media'.DS.'com_magicthumb');
    //}

    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_MAGICTHUMB_UNINSTALL_TEXT').'</p>
          </div>';

    sendJoomlaMagicthumbModuleStat('uninstall');
    return true;

}

class com_magicthumbInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagicthumbForJoomla();
    }

    function update($parent) {
        return installMagicthumbForJoomla();
    }

    function uninstall($parent) {
        return uninstallMagicthumbForJoomla();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendJoomlaMagicthumbModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v3.4.3' || 'working' == 'v3.0.20') {
        return;
    }

    /* 

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    if(class_exists('joomlaVersion')) {
        //old joomla, 1.0.x
        $versionObj = new joomlaVersion();
    } elseif(class_exists('JVersion')) {
        $versionObj = new JVersion();
    } else {
        return;
    }

    $platformVersion = $versionObj->getShortVersion();

    $path = "api/stat/?action={$action}&tool_name=magicthumb&license=trial&tool_version=v3.0.20&module_version=v3.4.3&platform_name=joomla&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

    */

}
