<?php

/*------------------------------------------------------------------------
# plg_system_magicscroll - Magic Scroll for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicscroll/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

global $displayMagicScrollForJoomlaHeaders;

if(!defined('MAGICSCROLL_FOR_JOOMLA_INIT')) {
    define('MAGICSCROLL_FOR_JOOMLA_INIT', true);
    defined('DS') or define('DS', DIRECTORY_SEPARATOR);
    defined('JVERSION_16') or define('JVERSION_16', version_compare(JVERSION, '1.6.0','>=') ? true : false);
    defined('JVERSION_30') or define('JVERSION_30', version_compare(JVERSION, '3.0.0','>=') ? true : false);
    $displayMagicScrollForJoomlaHeaders = false;
}

if(!defined('MAGICTOOLBOX_JURI_BASE')) {
    $url = JURI::base(true);
    //NOTE: JURI::base() return URI according to $live_site variable in configuration
    //      this leads to problem with wrong protocol prefix (http/https)
    //      so this is a fix
    if(empty($_SERVER['HTTPS']) || (strtolower($_SERVER['HTTPS']) == 'off')) {
        $url = preg_replace('/^https:/i', 'http:', $url);
    } else {
        $url = preg_replace('/^http:/i', 'https:', $url);
    }
    define('MAGICTOOLBOX_JURI_BASE', $url);
}

class PlgSystemMagicScroll extends JPlugin {

    protected static $instance = null;

    public function __construct(&$subject, $config = array()) {
        parent::__construct($subject, $config);
        if(is_null(self::$instance)) {
            self::$instance = $this;
        }
        //$this->loadLanguage();
    }

    public static function getInstance() {
        if(is_null(self::$instance)) {
            self::$instance = new PlgSystemMagicScroll(JEventDispatcher::getInstance(), JPluginHelper::getPlugin('system', 'magicscroll'));
        }
        return self::$instance;
    }

    public function onAfterRender() {

		$app = JFactory::getApplication();
		if($app->isClient('administrator')) return;

        global $displayMagicScrollForJoomlaHeaders;

        $tool = $this->getToolMagicScrollForJoomla();

        if (JVERSION>'4.0') {            
            $contents = JFactory::getApplication()->getBody();
        } else {
            $contents = JResponse::getBody();
        }

        if(!$tool->params->checkValue('enable-effect', 'No', 'default')) {

            $tool->params->setProfile('default');

            //NOTE: added support for shortcodes
            //      e.g. [magicscroll folder="images/magicscroll_shortcode_files/"]
            $matches = array();
            preg_match_all('/\[magicscroll\s*+folder\s*+=\s*+"([^"]*+)"\s*+\]/ims', $contents, $matches);
            if(!empty($matches[1])) {
                foreach($matches[1] as $i => $path) {
                    if(!empty($path)) {
                        //NOTE: fix directory separators
                        $path = preg_replace('#^(?:\\\\|/)++|(?:\\\\|/)++$#is', '', $path);
                        $path = preg_replace('#\\\\++|/++#is', DS, $path);

                        $folderPath = JPATH_SITE.DS.$path.DS;
                        $wsFolderPath = MAGICTOOLBOX_JURI_BASE.'/'.str_replace(DS, '/', $path).'/';

                        if(is_dir($folderPath)) {
                            $files = scandir($folderPath);
                            if(is_array($files)) {
                                $files = array_diff($files, array('.', '..'));
                                $html = '';
                                foreach($files as $file) {
                                    //if(preg_match('#.(?:bmp|gif|jpe?g|png|tiff?)$#is', $file) && is_file($folderPath.$file)) {
                                    //    $html .= '<img src="'.$wsFolderPath.$file.'"/>';
                                    //}
                                    $size = @getimagesize($folderPath.$file);
                                    if(is_array($size)) {
                                        $html .= '<img src="'.$wsFolderPath.$file.'"/>';
                                    }
                                }
                                if(!empty($html)) {
                                    $contents = str_replace($matches[0][$i], '<div class="MagicScroll">'.$html.'</div>', $contents);
                                }
                            }
                        }
                    }
                }
            }

            //NOTE: old pattern
            //<(p|div)\b([^>]*?\bclass=["\'][^"\']*?\bMagicScroll\b[^"\']*+["\'][^>]*+)>(.*?)</\1>
            $pattern =  '<(p|div)\b([^>]*?\bclass=["\'][^"\']*?\bMagicScroll\b[^"\']*+["\'][^>]*+)>'.
                        '('.
                        '(?:'.
                            '[^<]++'.
                            '|'.
                            '<(?!/?\1\b|!--)'.
                            '|'.
                            '<!--.*?-->'.
                            '|'.
                            '<\1\b[^>]*+>'.
                                '(?3)'.
                            '</\1\s*+>'.
                        ')*+'.
                        ')'.
                        '</\1\s*+>';

            //$contents = preg_replace_callback("#{$pattern}#is", 'callbackMagicScrollForJoomla', $contents);
            $contents = preg_replace_callback("#{$pattern}#is", array('PlgSystemMagicScroll', 'callbackMagicScrollForJoomla'), $contents);
            //preg_match_all('%'.$pattern.'%is', $contents, $__matches, PREG_SET_ORDER);


        }

        if(!$displayMagicScrollForJoomlaHeaders || defined('MagicScroll_HEADERS_LOADED')) return true;

        define('MagicScroll_HEADERS_LOADED', true);

        $tool->params->resetProfile();
        $url = MAGICTOOLBOX_JURI_BASE.'/media/plg_system_magicscroll';
        $headers = array();
        $headers[] = "\n".$tool->getHeadersTemplate($url);
        $headers[] = "\n<link type=\"text/css\" href=\"{$url}/magictoolbox.css\" rel=\"stylesheet\" media=\"screen\" />\n";
        $contents = preg_replace('#(<!-- Magic Slideshow Joomla module|</head>)#is', implode($headers).'$1', $contents, 1);

       if (JVERSION>'4.0') {            
            JFactory::getApplication()->setBody($contents);
        } else {
            JResponse::setBody($contents);
        }

        return true;
    }

    public function getToolMagicScrollForJoomla() {
        static $mainCoreClass = null;
        if($mainCoreClass === null) {
            require_once(dirname(__FILE__).DS.'magicscroll_classes'.DS.'magicscroll.module.core.class.php');
            $mainCoreClass = new MagicScrollModuleCoreClass();
            $database = JFactory::getDBO();
            $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__magicscroll_config` WHERE `disabled`='0'");
            $results = $database->loadAssocList();
            if(!empty($results)) {
                foreach($results as $row) {
                    $mainCoreClass->params->setValue($row['name'], $row['value'], $row['profile']);
                }
                //$mainCoreClass->params->setValue('item-tag', 'A', 'custom_slideshow');
            }
        }
        return $mainCoreClass;
    }

    public function callbackMagicScrollForJoomla($_matches) {


        $tool = $this->getToolMagicScrollForJoomla();
        $additionalClasses = $tool->params->getValue('scroll-extra-styles');
        if(!empty($additionalClasses)) {
            $_matches[2] = str_replace('MagicScroll', 'MagicScroll '.$additionalClasses, $_matches[2]);
        }
        $html = "<div{$_matches[2]}>{$_matches[3]}</div>";
        /*
        $matches = array();
        $id = '';
        if(preg_match('#\bid\s*+=\s*+["\']([^"\']*+)["\']#is', $attributes, $_matches[2])) {
            $id = $matches[1];
        } else {
            $id = md5($html);
            $html = preg_replace('#<div\b#i', '<div id="'.$id.'"', $html, 1);
        }
        $html .= '<script type="text/javascript">MagicScroll.extraOptions[\''.$id.'\'] = {\'item-tag\':\'img\'};</script>';
        */

        global $displayMagicScrollForJoomlaHeaders;
        $displayMagicScrollForJoomlaHeaders = true;

        return $html;
    }

}
