<?php

/*------------------------------------------------------------------------
# mod_magicscroll - Magic Scroll for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicscroll/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

//NOTE: this file is included in JModuleHelper::renderModule function

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

global $displayMagicScrollForJoomlaHeaders;
global $plgSystemMagicScroll;

if(!class_exists('PlgSystemMagicScroll')) return;//NOTE: plugin disabled

//JPluginHelper::importPlugin('system', 'magicscroll')
$plgSystemMagicScroll = PlgSystemMagicScroll::getInstance();

if(!defined('MAGICSCROLL_FOR_JOOMLA_FUNCTIONS_DEFINED')) {

    define('MAGICSCROLL_FOR_JOOMLA_FUNCTIONS_DEFINED', true);

    function getImageMagicScrollForJoomla($path, $type = 'original', $id = null) {
        static $imageHelper = null;
        if($imageHelper === null) {
            $classesFolded = JVERSION_16 ? 'magicscroll'.DS.'magicscroll_classes' : 'magicscroll_classes';
            require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.$classesFolded.DS.'magictoolbox.imagehelper.class.php');
            global $plgSystemMagicScroll;
            $tool = $plgSystemMagicScroll->getToolMagicScrollForJoomla();
            $imageHelper = new MagicToolboxImageHelperClass(JPATH_SITE,
                                                            DS.'media'.DS.'mod_magicscroll'.DS.'magictoolbox_cache',
                                                            $tool->params,
                                                            null,
                                                            MAGICTOOLBOX_JURI_BASE);
        }
        if(!$path || !is_file(JPATH_SITE.$path)) {
            return '';
        }
        return $imageHelper->create($path, $type, $id);
    }

}

$magicscroll = $plgSystemMagicScroll->getToolMagicScrollForJoomla();

$view = trim(JFactory::getApplication()->input->get('view'));
$homepage = $view == 'frontpage' || JVERSION_16 && $view == 'featured';
defined('JVERSION_25') or define('JVERSION_25', version_compare(JVERSION, '2.5.0','>=') ? true : false);
/*
//NOTE: for Joomla 1.5
$applicationMenu = & JSite::getMenu();
if($applicationMenu->getActive() == $applicationMenu->getDefault()) {
    $homepage = true;
}
*/
//NOTE: for Joomla 2.5 and 3.x
if(JVERSION_25/*JVERSION_30*/) {
    $applicationMenu = JFactory::getApplication()->getMenu();
    if($applicationMenu->getActive() == $applicationMenu->getDefault(JFactory::getLanguage()->getTag())) {
        $homepage = true;
    }
}

if($homepage && !$magicscroll->params->checkValue('enable-effect', 'No', 'custom_slideshow')) {

    $magicscroll->params->setProfile('custom_slideshow');
    $database = JFactory::getDBO();
    $database->setQuery("SELECT * FROM `#__magicscroll_images` WHERE `exclude`='0' ORDER BY `order`");
    $imagesData = $database->loadAssocList();
    if(!empty($imagesData)) {
        $baseImagePath = DS.'images'.DS.'magicscroll'.DS;
        foreach($imagesData as &$imageData) {
            $imageData['alt'] = $imageData['title'];
            $imageData['img'] = getImageMagicScrollForJoomla($baseImagePath.$imageData['name'], 'thumb', 'custom_slideshow');
            //$imageData['description'] = '<br/ >'.$imageData['description'];
            $imageData['link'] = $imageData['link'];
                                 //empty($imageData['link']) ? false : $imageData['link'];
        }
        //$itemsCount = count($imagesData);
        //if($itemsCount < $magicscroll->params->getValue('items')) {
        //    $magicscroll->params->setValue('items', $itemsCount);
        //}
        $magicscrollHTML = $magicscroll->getMainTemplate($imagesData, array('id' => 'customMagicScroll'));
        //require(JModuleHelper::getLayoutPath('mod_magicscroll'));//modules/mod_magicscroll/tmpl/default.php

        $displayMagicScrollForJoomlaHeaders = true;

        /*
        //NOTE: display headers if need it
        if(!defined('MagicScroll_HEADERS_LOADED')) {
            define('MagicScroll_HEADERS_LOADED', true);
            $magicscroll->params->resetProfile();
            $magicscrollURL = MAGICTOOLBOX_JURI_BASE.'/media/mod_magicscroll';
            $magicscrollHeaders = array();
            $magicscrollHeaders[] = "\n".$magicscroll->getHeadersTemplate($magicscrollURL);
            $magicscrollHeaders[] = "\n<link type=\"text/css\" href=\"{$magicscrollURL}/module.css\" rel=\"stylesheet\" media=\"screen\" />\n";
            echo implode($magicscrollHeaders);
        }
        */

        echo $magicscrollHTML;

    }

}
