<?php

/*------------------------------------------------------------------------
# com_magic360 - Magic 360 for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magic360/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagic360ForJoomla();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagic360ForJoomla();
    }
}

function installMagic360ForJoomla() {

    $database = JFactory::getDBO();
    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__magic360_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count) {
        $database->setQuery("DROP TABLE IF EXISTS `#__magic360_config_bak`;");
        $database->execute();
        $database->setQuery("RENAME TABLE `#__magic360_config` TO `#__magic360_config_bak`;");
        if($database->execute()) {
            $database->setQuery("CREATE TABLE `#__magic360_config` LIKE `#__magic360_config_bak`;");
            if($database->execute()) {
                $results->count = 0;
            }
        }
    }
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__magic360_config` (`profile`, `name`, `value`, `default`, `disabled`) VALUES
 ('default', 'columns', '36', '36', '0'),
 ('default', 'magnify', 'Yes', 'Yes', '0'),
 ('default', 'magnifier-width', '80%', '80%', '0'),
 ('default', 'magnifier-shape', 'inner', 'inner', '0'),
 ('default', 'fullscreen', 'Yes', 'Yes', '0'),
 ('default', 'spin', 'drag', 'drag', '0'),
 ('default', 'autospin-direction', 'clockwise', 'clockwise', '0'),
 ('default', 'sensitivityX', '50', '50', '0'),
 ('default', 'sensitivityY', '50', '50', '0'),
 ('default', 'mousewheel-step', '1', '1', '0'),
 ('default', 'autospin-speed', '3600', '3600', '0'),
 ('default', 'smoothing', 'Yes', 'Yes', '0'),
 ('default', 'autospin', 'once', 'once', '0'),
 ('default', 'autospin-start', 'load,hover', 'load,hover', '0'),
 ('default', 'autospin-stop', 'click', 'click', '0'),
 ('default', 'initialize-on', 'load', 'load', '0'),
 ('default', 'start-column', '1', '1', '0'),
 ('default', 'start-row', 'auto', 'auto', '0'),
 ('default', 'loop-column', 'Yes', 'Yes', '0'),
 ('default', 'loop-row', 'No', 'No', '0'),
 ('default', 'reverse-column', 'No', 'No', '0'),
 ('default', 'reverse-row', 'No', 'No', '0'),
 ('default', 'column-increment', '1', '1', '0'),
 ('default', 'row-increment', '1', '1', '0'),
 ('default', 'show-message', 'No', 'No', '0'),
 ('default', 'message', 'Drag image to spin', 'Drag image to spin', '0'),
 ('default', 'loading-text', 'Loading...', 'Loading...', '0'),
 ('default', 'fullscreen-loading-text', 'Loading large spin...', 'Loading large spin...', '0'),
 ('default', 'hint', 'Yes', 'Yes', '0'),
 ('default', 'hint-text', 'Drag to spin', 'Drag to spin', '0'),
 ('default', 'mobile-hint-text', 'Swipe to spin', 'Swipe to spin', '0'),
 ('default', 'version', '3.4.3', '3.4.3', '0');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_magic360&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The plugin will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendJoomlaMagic360ModuleStat('install');
    return true;
}

function uninstallMagic360ForJoomla() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_magic360', JPATH_ADMINISTRATOR, null, false);
    }

    $database = JFactory::getDBO();

    //NOTE: uninstall plugin
    if(version_compare(JVERSION, '1.6.0', '<')) {
        $query = "DELETE FROM `#__plugins` WHERE element='magic360'";
    } else {
        $query = "DELETE FROM `#__extensions` WHERE element='magic360'";
    }
    $database->setQuery($query);
    $database->execute();

    //$manifest = file_exists(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360'.DS.'magic360.xml') ? simplexml_load_file(JPATH_SITE.DS.'pugins'.DS.'system'.DS.'magic360'.DS.'magic360.xml') : false;//SimpleXMLElement
    //if($manifest) {
    //}
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magic360.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magic360.ini');
    }
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magic360.sys.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_magic360.sys.ini');
    }
    if(is_dir(JPATH_SITE.DS.'media'.DS.'plg_system_magic360')) {
        JFolder::delete(JPATH_SITE.DS.'media'.DS.'plg_system_magic360');
    }
    if(version_compare(JVERSION, '1.6.0', '<')) {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360_classes')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360_classes');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360.php')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360.php');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360.xml')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360.xml');
        }
    } else {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'magic360');
        }
    }


    //if(is_dir(JPATH_SITE.DS.'media'.DS.'com_magic360')) {
    //    JFolder::delete(JPATH_SITE.DS.'media'.DS.'com_magic360');
    //}

    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_MAGIC360_UNINSTALL_TEXT').'</p>
          </div>';

    sendJoomlaMagic360ModuleStat('uninstall');
    return true;

}

class com_magic360InstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagic360ForJoomla();
    }

    function update($parent) {
        return installMagic360ForJoomla();
    }

    function uninstall($parent) {
        return uninstallMagic360ForJoomla();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendJoomlaMagic360ModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v3.4.3' || 'working' == 'v4.6.13') {
        return;
    }

    /* 

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    if(class_exists('joomlaVersion')) {
        //old joomla, 1.0.x
        $versionObj = new joomlaVersion();
    } elseif(class_exists('JVersion')) {
        $versionObj = new JVersion();
    } else {
        return;
    }

    $platformVersion = $versionObj->getShortVersion();

    $path = "api/stat/?action={$action}&tool_name=magic360&license=trial&tool_version=v4.6.13&module_version=v3.4.3&platform_name=joomla&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

    */

}
