<?php

/*------------------------------------------------------------------------
# plg_system_magic360 - Magic 360 for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magic360/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

global $displayMagic360ForJoomlaHeaders;

if(!defined('MAGIC360_FOR_JOOMLA_INIT')) {
    define('MAGIC360_FOR_JOOMLA_INIT', true);
    defined('DS') or define('DS', DIRECTORY_SEPARATOR);
    defined('JVERSION_16') or define('JVERSION_16', version_compare(JVERSION, '1.6.0','>=') ? true : false);
    defined('JVERSION_30') or define('JVERSION_30', version_compare(JVERSION, '3.0.0','>=') ? true : false);
    $displayMagic360ForJoomlaHeaders = false;
}

if(!defined('MAGICTOOLBOX_JURI_BASE')) {
    $url = JURI::base(true);
    //NOTE: JURI::base() return URI according to $live_site variable in configuration
    //      this leads to problem with wrong protocol prefix (http/https)
    //      so this is a fix
    if(empty($_SERVER['HTTPS']) || (strtolower($_SERVER['HTTPS']) == 'off')) {
        $url = preg_replace('/^https:/i', 'http:', $url);
    } else {
        $url = preg_replace('/^http:/i', 'https:', $url);
    }
    define('MAGICTOOLBOX_JURI_BASE', $url);
}

class PlgSystemMagic360 extends JPlugin {

    protected static $instance = null;

    public function __construct(&$subject, $config = array()) {
        parent::__construct($subject, $config);
        if(is_null(self::$instance)) {
            self::$instance = $this;
        }
        //$this->loadLanguage();
    }

    public static function getInstance() {
        if(is_null(self::$instance)) {
            self::$instance = new PlgSystemMagic360(JEventDispatcher::getInstance(), JPluginHelper::getPlugin('system', 'magic360'));
        }
        return self::$instance;
    }

    public function onAfterRender() {

		$app = JFactory::getApplication();
		if($app->isClient('administrator')) return;

        global $displayMagic360ForJoomlaHeaders;

        $tool = $this->getToolMagic360ForJoomla();

        if (JVERSION>'4.0') {            
            $contents = JFactory::getApplication()->getBody();
        } else {
            $contents = JResponse::getBody();
        }

        if(!$tool->params->checkValue('enable-effect', 'No', 'default')) {

            $tool->params->setProfile('default');


            //NOTE: old pattern
            //'<a\b([^>]*?\bclass=["\'][^"\']*?\bMagic360\b[^"\']*+["\'][^>]*+)>(.*?)</a>'
            $pattern =  str_replace('MagicZoomPlus','MagicZoom(?:Plus)?','(?:<p[^>]*+>[^<]*+)?<a\b([^>]*?\bclass=["\'][^"\']*?\bMagic360\b[^"\']*+["\'][^>]*+)>').
                        '('.
                        '(?:'.
                            '[^<]++'.
                            '|'.
                            '<(?!/?a\b|!--)'.
                            '|'.
                            '<!--.*?-->'.
                            '|'.
                            '<a\b[^>]*+>'.
                                '(?2)'.
                            '</a\s*+>'.
                        ')*+'.
                        ')'.
                        '</a\s*+>(?:[^<]*+</p\s*+>)?';

            //$contents = preg_replace_callback("#{$pattern}#is", 'callbackMagic360ForJoomla', $contents);
            $contents = preg_replace_callback("#{$pattern}#is", array('PlgSystemMagic360', 'callbackMagic360ForJoomla'), $contents);
            //preg_match_all('%'.$pattern.'%is', $contents, $__matches, PREG_SET_ORDER);

            //NOTE: to fix relative URLs (rev/data-image/... etc tags) (like SEF plugin)
            //NOTE: using the previous pattern
            $contents = preg_replace_callback("#{$pattern}#is", array('PlgSystemMagic360', 'callbackMagic360ForJoomlaFixURL'), $contents);

        }
        else return true;

        if(!$displayMagic360ForJoomlaHeaders || defined('Magic360_HEADERS_LOADED')) return true;

        define('Magic360_HEADERS_LOADED', true);

        $tool->params->resetProfile();
        $url = MAGICTOOLBOX_JURI_BASE.'/media/plg_system_magic360';
        $headers = array();
        $headers[] = "\n".$tool->getHeadersTemplate($url);
        $headers[] = "\n<link type=\"text/css\" href=\"{$url}/magictoolbox.css\" rel=\"stylesheet\" media=\"screen\" />\n";
        $contents = preg_replace('#(<!-- Magic Slideshow Joomla module|</head>)#is', implode($headers).'$1', $contents, 1);

       if (JVERSION>'4.0') {            
            JFactory::getApplication()->setBody($contents);
        } else {
            JResponse::setBody($contents);
        }

        return true;
    }

    public function getToolMagic360ForJoomla() {
        static $mainCoreClass = null;
        if($mainCoreClass === null) {
            require_once(dirname(__FILE__).DS.'magic360_classes'.DS.'magic360.module.core.class.php');
            $mainCoreClass = new Magic360ModuleCoreClass();
            $database = JFactory::getDBO();
            $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__magic360_config` WHERE `disabled`='0'");
            $results = $database->loadAssocList();
            if(!empty($results)) {
                foreach($results as $row) {
                    $mainCoreClass->params->setValue($row['name'], $row['value'], $row['profile']);
                }
            }
        }
        return $mainCoreClass;
    }

    public function callbackMagic360ForJoomla($_matches) {

        $original = &$_matches[0];
        $attributes = &$_matches[1];
        $innerHTML = &$_matches[2];

        $html = $_matches[0];

        global $displayMagic360ForJoomlaHeaders;
        $displayMagic360ForJoomlaHeaders = true;

        return $html;
    }

    public function callbackMagic360ForJoomlaFixURL($_matches) {
        $protocols = '[a-zA-Z0-9\-]+:';
        $pattern = '\bdata-magic360-options\s*+=\s*+["\']([^"\']*+)["\']';
        if(preg_match('#'.$pattern.'#is', $_matches[0], $optionsMatch)) {
            $pattern = '\b(?:large-)?images\s*+:\s*+([^;]*+);?';
            if(preg_match_all('#'.$pattern.'#is', $optionsMatch[1], $matches, PREG_SET_ORDER)) {
                foreach($matches as $match) {
                    $_images = explode(' ', $match[1]);
                    $images = array();
                    foreach($_images as $image) {
                        $image = trim($image);
                        if(empty($image) || preg_match('#^(?=/|'.$protocols.')#is', $image)) continue;
                        $images[] = MAGICTOOLBOX_JURI_BASE.'/'.$image;
                    }
                    $attribute = str_replace($match[1], implode(' ', $images), $match[0]);
                    $_matches[0] = str_replace($match[0], $attribute, $_matches[0]);
                }
            }
        }

        return $_matches[0];

    }

}
