<?php

/*------------------------------------------------------------------------
# com_magic360 - Magic 360 for Joomla
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magic360/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla controller library
jimport('joomla.application.component.controller');

if(!defined('MAGICTOOLBOX_LEGACY_CONTROLLER_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_CONTROLLER_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyController extends JControllerLegacy {}
    } else {
        class MagicToolboxLegacyController extends JController {}
    }
}

class Magic360Controller extends MagicToolboxLegacyController {

    public function display($cachable = false, $urlparams = false) {
        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $app->input->set('view' , $app->input->get('view' , 'default')  );
        } else {
            JRequest::setVar('view', JRequest::getCmd('view', 'default'));
        }
        parent::display($cachable, $urlparams);
        return $this;
    }

    public function install() {

        $app = JFactory::getApplication();
        $database = JFactory::getDBO();

        $pluginPackageDir = dirname(__FILE__).DS.'plugin';

        //NOTE: to fix URL's in css files
        $this->fixCSS();

        jimport('joomla.installer.installer');

        if(!JVERSION_16) {
            //NOTE: it is important, that XML file name matches module name. Otherwise, Joomla wouldn't show parameters and additional info stored in XML.
            copy($pluginPackageDir.DS.'magic360_j15.xml', $pluginPackageDir.DS.'magic360.xml');
        }

        $installer = new JInstaller();//JInstaller::getInstance();
        $installer->setOverwrite(true);
        if($installer->install($pluginPackageDir)) {
            $app->enqueueMessage(JText::_('COM_MAGIC360_INSTALL_PLUGIN_SUCCESS'), 'message');

            //NOTE: enable plugin
            if(JVERSION_16) {
                $query = "UPDATE `#__extensions` SET `enabled`=1 WHERE `name`='plg_system_magic360'";
            } else {
                $query = "UPDATE `#__plugins` SET `published`=1, `name`='System - Magic360' WHERE `name`='plg_system_magic360'";
            }
            $database->setQuery($query);
            if(!$database->execute()) {
                $app->enqueueMessage(JText::_($database->getErrorMsg()), 'error');
            }

        } else {
            $app->enqueueMessage(JText::_('COM_MAGIC360_INSTALL_PLUGIN_ERROR'), 'error');
        }

        $this->setRedirect(JRoute::_('index.php?option=com_magic360', false));

        return $this;
    }

    public function fixCSS() {

        //NOTE: to fix URL's in css files

        $path = dirname(__FILE__).DS.'plugin'.DS.'media';
        $list = glob($path.'/*');
        $files = array();
        if(is_array($list)) {
            for($i = 0; $i < count($list); $i++) {
                if(is_dir($list[$i])) {
                    if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                        $add = glob($list[$i].'/*');
                        if(is_array($add)) {
                            $list = array_merge($list, $add);
                        }
                    }
                } else if(preg_match('#\.css$#i', $list[$i])) {
                    $files[] = $list[$i];
                }
            }
        }

        foreach($files as $file) {
            if(!is_writable($file)) {
                continue;
            }
            $cssPath = dirname($file);
            $cssRelPath = str_replace($path, '', $cssPath);
            $toolPath = JURI::root(true).'/media/plg_system_magic360'.$cssRelPath;
            $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
            $replace = 'url($1'.$toolPath.'/$2$1)';
            $fileContents = file_get_contents($file);
            $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
            //preg_match_all($pattern, $fileContents, $matches, PREG_SET_ORDER);
            //debug_log($matches);
            if($fixedFileContents != $fileContents) {
                $fp = fopen($file, 'w+');
                if($fp) {
                    fwrite($fp, $fixedFileContents);
                    fclose($fp);
                }
            }
        }

    }

    public function apply() {
        $this->saveParamsToDB();
        $this->setMessage(JText::_('COM_MAGIC360_SAVE_TEXT'), 'message');

        $tab = JFactory::getApplication()->input->get('magic_tabs_current', 'default', 'post');

        $tab = ($tab == 'default' ? '' : '&tab='.$tab);
        $this->setRedirect(JRoute::_('index.php?option=com_magic360'.$tab, false));
        return $this;
    }

    public function save() {
        $this->saveParamsToDB();
        $this->setMessage(JText::_('COM_MAGIC360_SAVE_TEXT'), 'message');
        $this->setRedirect(JRoute::_('index.php', false));
        return $this;
    }

    public function cancel() {
        $this->setRedirect(JRoute::_('index.php', false));
        return $this;
    }

    public function saveParamsToDB() {
        

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $post = $app->input->post->getArray();
        } else {
            $post = JRequest::get('post');
        }


        $database = JFactory::getDBO();
        if(!empty($post) && !empty($post['magic360']) && is_array($post['magic360'])) {
            $database->setQuery("UPDATE `#__magic360_config` SET disabled='1' WHERE profile!='default'");
            $database->execute();
            $profiles = array('default' => false);
            foreach($post['magic360'] as $profile => $params) {
                if(!isset($profiles[$profile]) || !is_array($params)) continue;
                foreach($params as $name => $value) {
                    $value = $database->quote($value);
                    $database->setQuery("UPDATE `#__magic360_config` SET `value`={$value}, `disabled`='0' WHERE profile='{$profile}' AND name='{$name}'");
                    $database->execute();
                }
            }
        }
    }

}
