<?php

defined('_JEXEC') or die('Restricted access');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagiczoomplusForHikashop();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagiczoomplusForHikashop();
    }
}

function installMagiczoomplusForHikashop() {

    $database = JFactory::getDBO();
    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__hikashop_magiczoomplus_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count) {
        $database->setQuery("DROP TABLE IF EXISTS `#__hikashop_magiczoomplus_config_bak`;");
        $database->execute();
        $database->setQuery("RENAME TABLE `#__hikashop_magiczoomplus_config` TO `#__hikashop_magiczoomplus_config_bak`;");
        if($database->execute()) {
            $database->setQuery("CREATE TABLE `#__hikashop_magiczoomplus_config` LIKE `#__hikashop_magiczoomplus_config_bak`;");
            if($database->execute()) {
                $results->count = 0;
            }
        }
    }
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__hikashop_magiczoomplus_config` (`block`, `name`, `value`, `default`) VALUES
 ('default', 'enable-effect', 'Yes', 'Yes'),
 ('default', 'template', 'bottom', 'bottom'),
 ('default', 'magicscroll', 'No', 'No'),
 ('default', 'thumb-max-width', '450', '450'),
 ('default', 'thumb-max-height', '450', '450'),
 ('default', 'zoomWidth', 'auto', 'auto'),
 ('default', 'zoomHeight', 'auto', 'auto'),
 ('default', 'zoomPosition', 'right', 'right'),
 ('default', 'zoomDistance', '15', '15'),
 ('default', 'square-images', 'disable', 'disable'),
 ('default', 'selectorTrigger', 'click', 'click'),
 ('default', 'transitionEffect', 'Yes', 'Yes'),
 ('default', 'selector-max-width', '70', '70'),
 ('default', 'selector-max-height', '70', '70'),
 ('default', 'lazyZoom', 'No', 'No'),
 ('default', 'rightClick', 'No', 'No'),
 ('default', 'cssClass', '', ''),
 ('default', 'show-message', 'No', 'No'),
 ('default', 'message', 'Move your mouse over image or click to enlarge', 'Move your mouse over image or click to enlarge'),
 ('default', 'imagemagick', 'off', 'off'),
 ('default', 'image-quality', '75', '75'),
 ('default', 'zoomMode', 'zoom', 'zoom'),
 ('default', 'zoomOn', 'hover', 'hover'),
 ('default', 'upscale', 'Yes', 'Yes'),
 ('default', 'smoothing', 'Yes', 'Yes'),
 ('default', 'variableZoom', 'No', 'No'),
 ('default', 'zoomCaption', 'off', 'off'),
 ('default', 'expand', 'window', 'window'),
 ('default', 'expandZoomMode', 'zoom', 'zoom'),
 ('default', 'expandZoomOn', 'click', 'click'),
 ('default', 'expandCaption', 'Yes', 'Yes'),
 ('default', 'closeOnClickOutside', 'Yes', 'Yes'),
 ('default', 'watermark', '', ''),
 ('default', 'watermark-max-width', '30%', '30%'),
 ('default', 'watermark-max-height', '30%', '30%'),
 ('default', 'watermark-opacity', '50', '50'),
 ('default', 'watermark-position', 'center', 'center'),
 ('default', 'watermark-offset-x', '0', '0'),
 ('default', 'watermark-offset-y', '0', '0'),
 ('default', 'hint', 'once', 'once'),
 ('default', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom'),
 ('default', 'textClickZoomHint', 'Click to zoom', 'Click to zoom'),
 ('default', 'textExpandHint', 'Click to expand', 'Click to expand'),
 ('default', 'textBtnClose', 'Close', 'Close'),
 ('default', 'textBtnNext', 'Next', 'Next'),
 ('default', 'textBtnPrev', 'Previous', 'Previous'),
 ('default', 'zoomModeForMobile', 'off', 'off'),
 ('default', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom'),
 ('default', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom'),
 ('default', 'textExpandHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('default', 'width', 'auto', 'auto'),
 ('default', 'height', 'auto', 'auto'),
 ('default', 'orientation', 'horizontal', 'horizontal'),
 ('default', 'mode', 'scroll', 'scroll'),
 ('default', 'items', '3', '3'),
 ('default', 'speed', '600', '600'),
 ('default', 'autoplay', '0', '0'),
 ('default', 'loop', 'infinite', 'infinite'),
 ('default', 'step', 'auto', 'auto'),
 ('default', 'arrows', 'inside', 'inside'),
 ('default', 'pagination', 'No', 'No'),
 ('default', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('default', 'scrollOnWheel', 'auto', 'auto'),
 ('default', 'lazy-load', 'No', 'No'),
 ('default', 'scroll-extra-styles', '', ''),
 ('default', 'show-image-title', 'No', 'No'),
 ('default', 'version', '1.3.4', '1.3.4');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_hikashop_magiczoomplus&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The frontend module will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendHikashopMagiczoomplusModuleStat('install');
    return true;
}

function uninstallMagiczoomplusForHikashop() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_hikashop_magiczoomplus', JPATH_ADMINISTRATOR, null, false);
    }

    //NOTE: uninstall module
    $module = 'mod_hikashop_magiczoomplus';
    $database = JFactory::getDBO();
    $query = "SELECT `id` FROM `#__modules` WHERE module='{$module}'";
    $database->setQuery($query);
    $modIDs = version_compare(JVERSION, '1.7.0', '<') ? $database->loadResultArray() : $database->loadColumn();
    if(count($modIDs)) {
        $modID = implode(',', $modIDs);
        $query = 'DELETE FROM #__modules_menu WHERE moduleid IN ('.$modID.')';
        $database->setQuery($query);
        $database->execute();
        $query = "DELETE FROM `#__modules` WHERE module='{$module}'";
        $database->setQuery($query);
        $database->execute();
        if(version_compare(JVERSION, '1.6.0', '>=')) {
            $query = "DELETE FROM `#__extensions` WHERE element='{$module}'";
            $database->setQuery($query);
            $database->execute();
        }
        //$query = "DELETE FROM `#__menu` WHERE link LIKE '%{$module}%'";
    }

    $manifest = file_exists(JPATH_SITE.DS.'modules'.DS.$module.DS."{$module}.xml") ? simplexml_load_file(JPATH_SITE.DS.'modules'.DS.$module.DS."{$module}.xml") : false;//SimpleXMLElement
    if($manifest) {
        $elements = array('media', 'languages');
        foreach($elements as $elementPath) {
            $element = $manifest->$elementPath;//SimpleXMLElement
            if(is_a($element, 'SimpleXMLElement') && count($element->children())) {
                switch($elementPath) {
                    case 'media':
                        $source = JPATH_SITE.DS.'media';
                        $destination = $element->attributes()->destination;
                        if($destination) {
                            $source = $source.DS.$destination;
                        }
                        break;
                    case 'languages':
                        $source = JPATH_SITE.DS.'language';
                        break;
                }
                foreach($element->children() as $child) {
                    if($child->getName() == 'language' && $child->attributes()->tag) {
                        $path = $source.DS.$child->attributes()->tag;
                        if(!JFolder::exists($path)) continue;
                        $path = $path.DS.$child;
                    } else {
                        $path = $source.DS.$child;
                    }
                    if(is_file($path)) {
                        JFile::delete($path);
                    } else if(is_dir($path)) {
                        $val = JFolder::delete($path);
                    }
                }
                //if($elementPath == 'media' && $destination) {
                //    JFolder::delete($source);
                //}
            }
        }
    }

    if(is_dir(JPATH_SITE.DS.'modules'.DS.$module)) {
        JFolder::delete(JPATH_SITE.DS.'modules'.DS.$module);
    }

    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_HIKASHOP_MAGICZOOMPLUS_UNINSTALL_TEXT').'</p>
          </div>';

    sendHikashopMagiczoomplusModuleStat('uninstall');
    return true;
}

class com_hikashop_magiczoomplusInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagiczoomplusForHikashop();
    }

    function update($parent) {
        return installMagiczoomplusForHikashop();
    }

    function uninstall($parent) {
        return uninstallMagiczoomplusForHikashop();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendHikashopMagiczoomplusModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.3.4' || 'working' == 'v5.3.7') {
        return;
    }
    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    $platformVersion = 'undefined';

    $database = JFactory::getDBO();
    //NOTICE: JDatabase::replacePrefix function does not replace prefix in quotes (' and ")
    $tablePrefix = $database->getPrefix();
    $query = "SHOW TABLES LIKE '{$tablePrefix}hikashop_config'";
    $database->setQuery($query);
    $table = $database->loadResult();
    if(!empty($table)) {
        $query = "SELECT `config_value` as `version` FROM `#__hikashop_config` WHERE config_namekey='version' LIMIT 1";
        $database->setQuery($query);
        $results = $database->loadObject();
        if(!empty($results)) {
            $platformVersion = $results->version;
        }
    }

    $path = "api/stat/?action={$action}&tool_name=magiczoomplus&license=trial&tool_version=v5.3.7&module_version=v1.3.4&platform_name=hikashop&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}
