<?php

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

defined( '_JEXEC' ) or die( 'Restricted access' );

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

//NOTE: is this hikashop component page?
if (JVERSION>'4') {
    $app = JFactory::getApplication();
    if($app->input->getCmd('hikashop_front_end_main', 'undefined') === 'undefined') return;
    $app->registerEvent( 'onAfterRender', 'magiczoomplusOnAfterRenderHandler' );
} else {
    if(JRequest::getVar('hikashop_front_end_main', 'undefined') === 'undefined') return;
    JDispatcher::getInstance()->register('onAfterRender', 'magiczoomplusOnAfterRenderHandler');
}

global $magiczoomplusSupportedBlocks;
$magiczoomplusSupportedBlocks = array('product');//array('default');

function magiczoomplusOnAfterRenderHandler() {

    global $magiczoomplusSupportedBlocks;
    if (JVERSION>'4') {
        $app = JFactory::getApplication();
        $page = trim($app->input->getCmd('view', ''));
    } else {
        $page = trim(JRequest::getVar('view', ''));
    }
    $tool = magiczoomplusGetTool();

    if(!in_array($page, $magiczoomplusSupportedBlocks) || $tool->params->checkValue('enable-effect', 'No', $page)) {
        return true;
    }

    if (!empty($_REQUEST['layout']) && $_REQUEST['layout']=='listing') {
        return true;
    }
    
    $tool->params->setProfile($page);

    if (JVERSION>'4') {
        $contents = JFactory::getApplication()->getBody();
    } else {
        $contents = JResponse::getBody();
    }

    $showHeaders = false;

    switch($page) {
        case 'product':
            $defaultID = $mainProductID = hikashop_getCID('product_id');

            $productClass = hikashop_get('class.product');
            $product=$productClass->get($mainProductID);
            if (!empty($product->product_parent_id)) {
                $mainProductID = $product->product_parent_id;
            }

            if (empty($mainProductID)) {
                return;
            }
            
            $database = JFactory::getDBO();
            $productTableName = hikashop_table('product');
            $fileTableName = hikashop_table('file');

            //NOTE: product variant ids
            $query = "SELECT product_id FROM {$productTableName} WHERE product_parent_id={$mainProductID} AND product_type='variant'";//ORDER BY product_parent_id ASC
            $database->setQuery($query);
            $productIDs = $database->loadAssocList(null, 'product_id');

            $variantCharacteristics = array();
            $defaultVariantProductID = null;

            if(empty($productIDs)) {
                //NOTE: add main product ID to the top (after checking)
                array_unshift($productIDs, $mainProductID);
            } else {
                //NOTE: add main product ID to the top (after checking)
                array_unshift($productIDs, $mainProductID);

                $variantTableName = hikashop_table('variant');
                $characteristicTableName = hikashop_table('characteristic');
                $hikashop_config = & hikashop_config();
                $sort = $hikashop_config->get('characteristics_values_sorting');
                if($sort=='old') {
                    $order = 'characteristic_id ASC';
                } else if($sort=='alias') {
                    $order = 'characteristic_alias ASC';
                } else if($sort=='ordering') {
                    $order = 'characteristic_ordering ASC';
                } else {
                    $order = 'characteristic_value ASC';
                }
                //NOTE: get characteristic ids
                $query  = "SELECT v.variant_product_id, c.characteristic_id FROM {$variantTableName} AS v LEFT JOIN {$characteristicTableName} AS c ".
                          "ON v.variant_characteristic_id=c.characteristic_id WHERE v.variant_product_id IN (".implode(',', $productIDs).") AND c.characteristic_parent_id!=0 ".
                          "ORDER BY v.ordering ASC,c.{$order}";
                $database->setQuery($query);
                $data = $database->loadAssocList();
                foreach($data as $item) {
                    if(!isset($variantCharacteristics[$item['variant_product_id']])) $variantCharacteristics[$item['variant_product_id']] = array();
                    $variantCharacteristics[$item['variant_product_id']][] = $item['characteristic_id'];
                }

                $defaultCharacteristicIDs = $variantCharacteristics[$mainProductID];
                unset($variantCharacteristics[$mainProductID]);
                foreach($variantCharacteristics as $variantID => $characteristicIDs) {
                    foreach($defaultCharacteristicIDs as $defaultCharacteristicID) {
                        if(!in_array($defaultCharacteristicID, $characteristicIDs)) continue 2;
                    }
                    $defaultVariantProductID = $variantID;
                    break;
                }
                if($defaultVariantProductID === null) {
                    //NOTE: there is no default variant product, possibly removed, use first variant
                    reset($variantCharacteristics);
                    $defaultVariantProductID = key($variantCharacteristics);
                }

            }


            $query = "SELECT product_id, product_name, product_description FROM {$productTableName} WHERE product_id IN (".implode(',', $productIDs).")";
            $database->setQuery($query);
            $productsData = $database->loadObjectList('product_id');
            //$mainProductName = '';
            //$mainProductDescription = '';

            //NOTE: first get HTML data for all products with images
            $htmlData = array();
            $patternData = array();
            foreach($productIDs as $productID) {

                $query = "SELECT file_name, file_path FROM {$fileTableName} WHERE file_ref_id={$productID} AND file_type='product' ORDER BY file_ref_id ASC, file_ordering ASC, file_id ASC";
                $database->setQuery($query);
                $imagesData = $database->loadObjectList();
                if(empty($imagesData)) continue;
                $title = empty($productsData[$productID]) || empty($productsData[$productID]->product_name) ? @$productsData[$mainProductID]->product_name : @$productsData[$productID]->product_name;
                $mainHtml = $tool->getMainTemplate(array(
                    'id' => "Product{$productID}",
                    'group' => "Product{$productID}",
                    'img' => magiczoomplusGetImage($imagesData[0]->file_path, 'original', $productID),
                    'thumb' => magiczoomplusGetImage($imagesData[0]->file_path, 'thumb', $productID),
                    'title' => $title,
                    'alt' => empty($imagesData[0]->file_name) ? $title : $imagesData[0]->file_name,
                    'description' => empty($productsData[$productID]) || empty($productsData[$productID]->product_description) ? @$productsData[$mainProductID]->product_description : @$productsData[$productID]->product_description,
                ));
                $selectorsHtml = array();
                if(count($imagesData) > 1) {
                    foreach($imagesData as $imageData) {
                        $selectorsHtml[] = $tool->getSelectorTemplate(array(
                            'id' => "Product{$productID}",
                            'img' => magiczoomplusGetImage($imageData->file_path, 'original', $productID),
                            'medium' => magiczoomplusGetImage($imageData->file_path, 'thumb', $productID),
                            'thumb' => magiczoomplusGetImage($imageData->file_path, 'selector', $productID),
                            'title' => empty($imageData->file_name) ? $title : $imageData->file_name,
                        ));
                    }
                }
                $scrollTool = magiczoomplusGetTool(true);
                $htmlData[$productID] = MagicToolboxTemplateHelperClass::render(array(
                    'main' => $mainHtml,
                    'thumbs' => $selectorsHtml,
                    'magicscrollOptions' => $scrollTool ? $scrollTool->params->serialize(false, '', 'product-magicscroll-options') : '',
                    'pid' => $productID,
                ));
                $patternData[$productID] = preg_quote(preg_replace('#^/+#', '', $imagesData[0]->file_path), '/');
            }


            //NOTE: unset main product id
            unset($productIDs[0]);

            //TODO: fix regexp to cut div by variant id
            //$patternTemplate = '<img [^>]*?src="[^"]*?\/__SRC__"[^>]*>';
            $patternTemplate = '.*?src="[^"]*?\/__SRC__".*?';
            //NOTE: main image id="hikashop_main_image_div"
            $patternTemplate = '<div [^>]*?class="hikashop_global_image_div"[^>]*>[^<]*'.
                               '<div [^>]*?class="hikashop_main_image_div"[^>]*>[^<]*'.
                                    '(?:<div [^>]*?class="hikashop_product_main_image_thumb"[^>]*>[^<]*'.
                                        '<div [^>]*?class="hikashop_product_main_image"[^>]*>[^<]*'.
                                            '<div [^>]*?class="hikashop_product_main_image_subdiv"[^>]*>[^<]*'.
                                                '<a[^>]*>[^<]*'.$patternTemplate.'.*?<\/a>[^<]*'.
                                            '<\/div>[^<]*'.
                                        '<\/div>[^<]*'.
                                    '<\/div>|'.$patternTemplate.')[^<]*'.
                                    '(?:<meta itemprop="image"[^>]*>[^<]*)?'.
                                '<\/div>[^<]*'.
                                '<div [^>]*?class="hikashop_small_image_div"[^>]*>[^<]*'.
                                    //'(?:<a [^>]*>[^<]*<img [^>]*>[^<]*<\/a>[^<]*)*'.
                                    '(?:<a [^>]*>.*?<\/a>[^<]*)*'.
                                '<\/div>'.
                                '[^<]*<\/div>';

            $reg = '<div id="hikashop_product_image_main".*?<\!\-\- EO THUMBNAILS \-\->[^<]*<\/div>[^<]*<script.*?<\/script>';
            if (preg_match('/'.$reg.'/ims', $contents)) {
                $patternTemplate = $reg;
            }

            if($defaultVariantProductID && isset($htmlData[$defaultVariantProductID])) {
                $defaultID = $defaultVariantProductID;
            }
            if(!isset($htmlData[$mainProductID])) {
                $hikashop_config = & hikashop_config();
                $htmlData[$mainProductID] = '<img src="'.magiczoomplusGetImage('', 'thumb').'" />';
                $patternData[$mainProductID] = preg_quote($hikashop_config->get('default_image'), '/');
            }


            $html = '';
            foreach($htmlData as $productID => $_html) {
                //$display = ($defaultID == $productID ? 'block' : 'none');
                //$html .= "<div id=\"imagesContainer{$productID}\" style=\"display: {$display};\"><div>{$_html}</div></div>";
                $html .= "<div id=\"imagesContainer{$productID}\" class=\"".($defaultID == $productID ? '' : 'magictoolboxHiddenElement')."\"><div>{$_html}</div></div>";
            }

            //NOTE: replace main product images (or default variant images)
            $pattern = str_replace('__SRC__', $patternData[$defaultID], $patternTemplate);

            /* hikashop badges */
            // preg_match_all('/id="hikashop_main_image".*?\/>(<div class="hikashop_badge.*?<\/div>)/ims', $contents, $m);
            // if (isset($m[1][0])) {
            //     $html = preg_replace('/(<div class="MagicToolboxContainer.*)>/ims', '$1 style="position:relative">'.str_replace('style="','style="pointer-events:none;',$m[1][0]), $html);
            // }
            preg_match('/'.$pattern.'/is', $contents, $mb);
            if (!empty($mb[0])) {
                preg_match_all('/id="hikashop_main_image".*?\/>(<div class="hikashop_badge.*?<\/div>)/ims', $mb[0], $m);
            }
            if (isset($m[1][0])) {
                $html = preg_replace('/(<div class="MagicToolboxContainer.*)>/ims', '$1 style="position:relative">'.str_replace('style="','style="pointer-events:none;',$m[1][0]), $html);
            }

            $old_contents = $contents;
            $contents = preg_replace('/'.$pattern.'/is', $html, $contents, 1);
            if ($old_contents == $contents) {
                $contents = preg_replace('/<!\-\- MAIN IMAGE.*?EO THUMBNAILS \-\->/ims', $html, $contents, 1);
            }


            //NOTE: cut off variant products images
            foreach($productIDs as $productID) {
                if(isset($patternData[$productID])) {
                    $pattern = str_replace('__SRC__', $patternData[$productID], $patternTemplate);
                } else {
                    $pattern = str_replace('__SRC__', $patternData[$mainProductID], $patternTemplate);
                }
                //$matches = array();
                //preg_match('/'.$pattern.'/is', $contents, $matches);
                //debug_log($matches);
                $contents = preg_replace('/'.$pattern.'/is', '', $contents, 1);
            }

            if(function_exists('magic360GetTool')) {
                $tool360 = magic360GetTool();
                if(!$tool360->params->checkValue('enable-effect', 'No', 'product')) {
                    global $globalHtmlData;
                    $globalHtmlData = $htmlData;
                }
            }

            $showHeaders = true;

        break;
    }

    if(!$showHeaders) return true;

    $tool->params->resetProfile();
    $url = JURI::base(true).'/media/mod_hikashop_magiczoomplus';
    $headers = array();
    $headers[] = "\n".$tool->getHeadersTemplate($url);
    if($page == 'product') {
        if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
            $scrollTool = magiczoomplusGetTool(true);
            $scrollTool->params->resetProfile();
            $headers[] = "\n".$scrollTool->getHeadersTemplate($url, $url, false);
        }
        $headers[] = "\n<script type=\"text/javascript\">";
        $headers[] = "\nvar magictoolboxMainProductID = {$mainProductID};";
        $headers[] = "\nvar magictoolboxCurrentProductID = {$defaultID};";
        $headers[] = "\nvar magictoolboxVariantCharacteristics = ".json_encode($variantCharacteristics).";";
        $headers[] = "
if(typeof(window['hikashopUpdateVariantData']) === 'function') {
    window['hikashopUpdateVariantDataMagicZoomPlusOriginal'] = window['hikashopUpdateVariantData'];
    window['hikashopUpdateVariantData'] = function(selection) {
        if(selection) {
            hikashopUpdateVariantDataMagicZoomPlusOriginal(selection);
            var matches = selection.match(/[0-9]+/g);
            var id = null;
            next:
            for(var variantID in magictoolboxVariantCharacteristics) {
                for(var i = 0; i < matches.length; i++) {
                    var notFound = true;
                    for(var j = 0; j < magictoolboxVariantCharacteristics[variantID].length; j++) {
                        if(magictoolboxVariantCharacteristics[variantID][j] == matches[i]) {
                            notFound = false;
                            break;
                        }
                    }
                    if(notFound) {
                        continue next;
                    }
                }
                id = variantID;
                break;
            }
            if(id) {
                var el = document.getElementById('imagesContainer'+id);
                if(!el) {
                    id = magictoolboxMainProductID;
                    el = document.getElementById('imagesContainer'+magictoolboxMainProductID);
                }
                if(magictoolboxCurrentProductID != id) {
                    /*document.getElementById('imagesContainer'+magictoolboxCurrentProductID).style.display = 'none';*/
                    /*el.style.display = 'block';*/
                    document.getElementById('imagesContainer'+magictoolboxCurrentProductID).className += ' magictoolboxHiddenElement';
                    el.className = el.className.replace(/\s?magictoolboxHiddenElement/g, '');
                    magictoolboxCurrentProductID = id;
                    var selectors = document.getElementById('MagicToolboxSelectors'+id);
                    window['MagicScroll'] && selectors && selectors.className.match(/MagicScroll/g) && MagicScroll.refresh(selectors);
                }
            }


        }
        return true;
    }
}";
        $headers[] = "\n</script>";
    }
    //$headers[] = "\n<link type=\"text/css\" href=\"{$url}/module.css\" rel=\"stylesheet\" media=\"screen\" />\n";
    $contents = preg_replace('/<\/body/is', implode($headers).'</body', $contents, 1);

    if (JVERSION>'4') {
        $contents = JFactory::getApplication()->setBody($contents);
    } else {
        JResponse::setBody($contents);
    }
    
    return true;
}

function magiczoomplusGetTool($getScrollTool = false) {
    static $mainCoreClass = null;
    static $scrollCoreClass = null;
    global $magiczoomplusSupportedBlocks;
    if($mainCoreClass === null) {
        require_once(dirname(__FILE__).DS.'classes'.DS.'magiczoomplus.module.core.class.php');
        $mainCoreClass = new MagicZoomPlusModuleCoreClass();
        $database = JFactory::getDBO();
        $database->setQuery("SELECT block, name, value FROM `#__hikashop_magiczoomplus_config`");
        $results = $database->loadAssocList();
        if(!empty($results)) {
            foreach($results as $row) {
                $mainCoreClass->params->setValue($row['name'], $row['value'], $row['block']);
            }
        }
        if($mainCoreClass->params->checkValue('magicscroll', 'Yes', 'product')) {
            require_once(dirname(__FILE__).DS.'classes'.DS.'magicscroll.module.core.class.php');
            $scrollCoreClass = new MagicScrollModuleCoreClass(false);
            //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
            //$scrollCoreClass->params->appendParams($mainCoreClass->params->getParams('product'), 'product-magicscroll-options');
            foreach($scrollCoreClass->params->getParams() as $id => $param) {
                $value = $mainCoreClass->params->getValue($id, 'product');
                if($value !== null) {
                    $scrollCoreClass->params->setValue($id, $value, 'product-magicscroll-options');
                }
            }
            $scrollCoreClass->params->setValue('orientation', ($mainCoreClass->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
            //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
            if(function_exists('magicscrollGetTool')) {
                magicscrollGetTool();
            }
        }
        require_once(dirname(__FILE__).DS.'classes'.DS.'magictoolbox.templatehelper.class.php');
        MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DIRECTORY_SEPARATOR.'templates');
        MagicToolboxTemplateHelperClass::setOptions($mainCoreClass->params);
    }
    return $getScrollTool ? $scrollCoreClass : $mainCoreClass;
}

function magiczoomplusGetImage($path, $type = 'original', $productId = null) {
    static $imageHelper = null;
    static $uploadFolder = '';
    static $defaultImage = '';
    static $defaultImageFolder = '';
    if($imageHelper === null) {
        require_once(dirname(__FILE__).DS.'classes'.DS.'magictoolbox.imagehelper.class.php');
        $tool = magiczoomplusGetTool();
        $imageHelper = new MagicToolboxImageHelperClass(JPATH_SITE,
                                                        DS.'media'.DS.'mod_hikashop_magiczoomplus'.DS.'magictoolbox_cache',
                                                        $tool->params,
                                                        null,
                                                        JURI::base(true));
        $config =& hikashop_config();
        $uploadFolder = DS.ltrim(JPath::clean(html_entity_decode($config->get('uploadfolder'))), DS);
        $uploadFolder = rtrim($uploadFolder, DS).DS;
        $defaultImage = $config->get('default_image');
        if($defaultImage == 'barcode.png') {
            $defaultImageFolder = DS.'media'.DS.HIKASHOP_COMPONENT.DS.'images'.DS;
        }
        if(!file_exists(HIKASHOP_ROOT.'media'.DS.HIKASHOP_COMPONENT.DS.'images'.DS.$defaultImage)) {
            $defaultImageFolder = $uploadFolder;
        }
    }
    if(!$path) {
        return $imageHelper->create($defaultImageFolder.$defaultImage, $type, $productId);
    }
    $path = preg_replace('#^/+#', '', $path);
    return $imageHelper->create($uploadFolder.$path, $type, $productId);
}
