<?php

defined('_JEXEC') or die('Restricted access');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla controller library
jimport('joomla.application.component.controller');

if(!defined('MAGICTOOLBOX_LEGACY_CONTROLLER_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_CONTROLLER_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyController extends JControllerLegacy {}
    } else {
        class MagicToolboxLegacyController extends JController {}
    }
}

class Hikashop_MagiczoomplusController extends MagicToolboxLegacyController {

    public function display($cachable = false, $urlparams = false) {
        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $app->input->set('view' , $app->input->get('view' , 'default')  );
        } else {
            JRequest::setVar('view', JRequest::getCmd('view', 'default'));
        }
        parent::display($cachable, $urlparams);
        return $this;
    }

    public function install() {
        jimport( 'joomla.installer.installer' );
        $installer = new JInstaller();//JInstaller::getInstance();
        $installer->setOverwrite(true);
        $packagDir = dirname(__FILE__).'/module';
        if(!JVERSION_16) {
            //NOTE: it is important, that XML file name matches module name. Otherwise, Joomla wouldn't show parameters and additional info stored in XML.
            copy($packagDir.'/mod_hikashop_magiczoomplus_j15.xml', $packagDir.'/mod_hikashop_magiczoomplus.xml');
        }
        if(!$installer->install($packagDir)) {
            $message = JText::_('COM_HIKASHOP_MAGICZOOMPLUS_INSTALL_ERROR');
            $messageType = 'error';
        } else {
            $title = JText::_('COM_HIKASHOP_MAGICZOOMPLUS_MODULE_TITLE');
            $database = JFactory::getDBO();
            $position = JVERSION_16 ? 'position-3' : 'left';
            $database->setQuery("UPDATE `#__modules` SET `title`='{$title}', `ordering`=0, `position`='{$position}', `published`=1, `showtitle`=0 WHERE `module`='mod_hikashop_magiczoomplus'");
            if($database->execute()) {
                $database->setQuery("INSERT IGNORE INTO `#__modules_menu` (`moduleid`, `menuid`) SELECT `m`.`id`, 0 FROM `#__modules`  AS `m` WHERE `m`.`module`='mod_hikashop_magiczoomplus'");
                $database->execute();
                $message = JText::_('COM_HIKASHOP_MAGICZOOMPLUS_INSTALL_SUCCESS');
                $messageType = 'message';
            } else {
                $message = JText::_($database->getErrorMsg());
                $messageType = 'error';
            }
        }
        $this->setMessage($message, $messageType);
        $this->setRedirect(JRoute::_('index.php?option=com_hikashop_magiczoomplus', false));
        return $this;
    }

    public function apply() {
        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $this->saveParamsToDB( $app->input->post->getArray() );
        } else {
            $this->saveParamsToDB(JRequest::get('post'));
        }
        $this->setMessage(JText::_('COM_HIKASHOP_MAGICZOOMPLUS_SAVE_TEXT'), 'message');
        $this->setRedirect(JRoute::_('index.php?option=com_hikashop_magiczoomplus', false));
        return $this;
    }

    public function save() {
        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $this->saveParamsToDB( $app->input->post->getArray() );
        } else {
            $this->saveParamsToDB(JRequest::get('post'));
        }
        $this->setMessage(JText::_('COM_HIKASHOP_MAGICZOOMPLUS_SAVE_TEXT'), 'message');
        $this->setRedirect(JRoute::_('index.php', false));
        return $this;
    }

    public function cancel() {
        $this->setRedirect(JRoute::_('index.php', false));
        return $this;
    }

    public function saveParamsToDB($params = array()) {
        if(empty($params)) return;
        //require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_hikashop_magiczoomplus'.DS.'module'.DS.'site'.DS.'classes'.DS.'magiczoomplus.module.core.class.php');
        //$tool = new MagicZoomPlusModuleCoreClass();
        $database = JFactory::getDBO();
        $blocks = array('default');
        foreach($params as $param => $value) {
            $pos = strpos($param, '-');
            if(!$pos) continue;
            $block = substr($param, 0, $pos);
            if(!in_array($block, $blocks)) continue;
            $name = substr($param, $pos+1);
            $value = $database->quote($value);
            $database->setQuery("UPDATE `#__hikashop_magiczoomplus_config` SET value={$value} WHERE block='{$block}' AND name='{$name}'");
            $database->execute();
        }
    }

}
