<?php

defined('_JEXEC') or die('Restricted access');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla view library
jimport('joomla.application.component.view');

if(!defined('MAGICTOOLBOX_LEGACY_VIEW_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_VIEW_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyView extends JViewLegacy {}
    } else {
        class MagicToolboxLegacyView extends JView {}
    }
}

class Hikashop_MagiczoomViewDefault extends MagicToolboxLegacyView {

    function display($tpl = null) {

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $app->input->set('hidemainmenu' , true );
        } else {
            JRequest::setVar('hidemainmenu', true);
        }

        $document = JFactory::getDocument();
        $document->addScript(JURI::root().'/media/com_hikashop_magiczoom/options.js');
        $document->addStyleSheet(JURI::root().'media/com_hikashop_magiczoom/backend.css');

        JToolBarHelper::title(JText::_('COM_HIKASHOP_MAGICZOOM_MANAGER_SETTINGS'), 'magiczoom.png');
        JToolBarHelper::save('save');//Save & Close
        JToolBarHelper::apply('apply');//Save
        JToolBarHelper::cancel('cancel', 'Close');//Close

        require_once(JPATH_SITE.DS.'modules'.DS.'mod_hikashop_magiczoom'.DS.'classes'.DS.'magiczoom.module.core.class.php');
        $this->tool = new MagicZoomModuleCoreClass();
        $database = JFactory::getDBO();
        $database->setQuery("SELECT block, name, value FROM `#__hikashop_magiczoom_config`");
        $results = $database->loadAssocList();
        if(!empty($results)) {
            foreach($results as $row) {
                $this->tool->params->setValue($row['name'], $row['value'], $row['block']);
            }
        }

        //NOTE: change subtype for some params to display them like radio
        foreach($this->tool->params->getParams() as $paramId => $param) {
           if($this->tool->params->getSubType($paramId) == 'select' && count($this->tool->params->getValues($paramId)) < 6)
               $this->tool->params->setSubType($paramId, 'radio');
        }

        $this->blocks = array('default' => 'Product page');
        $this->imageUrl = JURI::root().'media/com_hikashop_magiczoom/images/';
        $this->paramsMap = array(
			'default' => array(
				'General' => array(
					'enable-effect',
					'template',
					'magicscroll',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
					'square-images',
				),
				'Multiple images' => array(
					'selectorTrigger',
					'transitionEffect',
					'selector-max-width',
					'selector-max-height',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message',
					'imagemagick',
					'image-quality',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
				),
				'Scroll' => array(
					'width',
					'height',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
		);

        parent::display($tpl);

    }


}
