<?php

defined('_JEXEC') or die('Restricted access');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagicslideshowForHikashop();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagicslideshowForHikashop();
    }
}

function installMagicslideshowForHikashop() {

    $database = JFactory::getDBO();
    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__hikashop_magicslideshow_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count) {
        $database->setQuery("DROP TABLE IF EXISTS `#__hikashop_magicslideshow_config_bak`;");
        $database->execute();
        $database->setQuery("RENAME TABLE `#__hikashop_magicslideshow_config` TO `#__hikashop_magicslideshow_config_bak`;");
        if($database->execute()) {
            $database->setQuery("CREATE TABLE `#__hikashop_magicslideshow_config` LIKE `#__hikashop_magicslideshow_config_bak`;");
            if($database->execute()) {
                $results->count = 0;
            }
        }
    }
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__hikashop_magicslideshow_config` (`block`, `name`, `value`, `default`) VALUES
 ('default', 'enable-effect', 'Yes', 'Yes'),
 ('default', 'thumb-max-width', '450', '450'),
 ('default', 'thumb-max-height', '450', '450'),
 ('default', 'selector-max-width', '70', '70'),
 ('default', 'selector-max-height', '70', '70'),
 ('default', 'square-images', 'disable', 'disable'),
 ('default', 'width', 'auto', 'auto'),
 ('default', 'height', 'auto', 'auto'),
 ('default', 'orientation', 'horizontal', 'horizontal'),
 ('default', 'arrows', 'Yes', 'Yes'),
 ('default', 'loop', 'Yes', 'Yes'),
 ('default', 'effect', 'slide', 'slide'),
 ('default', 'effect-speed', '600', '600'),
 ('default', 'effect-easing', 'ease', 'ease'),
 ('default', 'autoplay', 'Yes', 'Yes'),
 ('default', 'slide-duration', '6000', '6000'),
 ('default', 'shuffle', 'No', 'No'),
 ('default', 'kenburns', 'No', 'No'),
 ('default', 'pause', 'Yes', 'Yes'),
 ('default', 'selectors-style', 'bullets', 'bullets'),
 ('default', 'selectors', 'none', 'none'),
 ('default', 'selectors-eye', 'Yes', 'Yes'),
 ('default', 'bullets-preview', 'top', 'top'),
 ('default', 'selectors-fill', 'No', 'No'),
 ('default', 'caption', 'Yes', 'Yes'),
 ('default', 'fullscreen', 'No', 'No'),
 ('default', 'preload', 'Yes', 'Yes'),
 ('default', 'keyboard', 'Yes', 'Yes'),
 ('default', 'show-loader', 'Yes', 'Yes'),
 ('default', 'show-message', 'No', 'No'),
 ('default', 'message', '', ''),
 ('default', 'imagemagick', 'off', 'off'),
 ('default', 'image-quality', '75', '75'),
 ('default', 'watermark', '', ''),
 ('default', 'watermark-max-width', '30%', '30%'),
 ('default', 'watermark-max-height', '30%', '30%'),
 ('default', 'watermark-opacity', '50', '50'),
 ('default', 'watermark-position', 'center', 'center'),
 ('default', 'watermark-offset-x', '0', '0'),
 ('default', 'watermark-offset-y', '0', '0'),
 ('default', 'version', '1.3.4', '1.3.4');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_hikashop_magicslideshow&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The frontend module will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendHikashopMagicslideshowModuleStat('install');
    return true;
}

function uninstallMagicslideshowForHikashop() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_hikashop_magicslideshow', JPATH_ADMINISTRATOR, null, false);
    }

    //NOTE: uninstall module
    $module = 'mod_hikashop_magicslideshow';
    $database = JFactory::getDBO();
    $query = "SELECT `id` FROM `#__modules` WHERE module='{$module}'";
    $database->setQuery($query);
    $modIDs = version_compare(JVERSION, '1.7.0', '<') ? $database->loadResultArray() : $database->loadColumn();
    if(count($modIDs)) {
        $modID = implode(',', $modIDs);
        $query = 'DELETE FROM #__modules_menu WHERE moduleid IN ('.$modID.')';
        $database->setQuery($query);
        $database->execute();
        $query = "DELETE FROM `#__modules` WHERE module='{$module}'";
        $database->setQuery($query);
        $database->execute();
        if(version_compare(JVERSION, '1.6.0', '>=')) {
            $query = "DELETE FROM `#__extensions` WHERE element='{$module}'";
            $database->setQuery($query);
            $database->execute();
        }
        //$query = "DELETE FROM `#__menu` WHERE link LIKE '%{$module}%'";
    }

    $manifest = file_exists(JPATH_SITE.DS.'modules'.DS.$module.DS."{$module}.xml") ? simplexml_load_file(JPATH_SITE.DS.'modules'.DS.$module.DS."{$module}.xml") : false;//SimpleXMLElement
    if($manifest) {
        $elements = array('media', 'languages');
        foreach($elements as $elementPath) {
            $element = $manifest->$elementPath;//SimpleXMLElement
            if(is_a($element, 'SimpleXMLElement') && count($element->children())) {
                switch($elementPath) {
                    case 'media':
                        $source = JPATH_SITE.DS.'media';
                        $destination = $element->attributes()->destination;
                        if($destination) {
                            $source = $source.DS.$destination;
                        }
                        break;
                    case 'languages':
                        $source = JPATH_SITE.DS.'language';
                        break;
                }
                foreach($element->children() as $child) {
                    if($child->getName() == 'language' && $child->attributes()->tag) {
                        $path = $source.DS.$child->attributes()->tag;
                        if(!JFolder::exists($path)) continue;
                        $path = $path.DS.$child;
                    } else {
                        $path = $source.DS.$child;
                    }
                    if(is_file($path)) {
                        JFile::delete($path);
                    } else if(is_dir($path)) {
                        $val = JFolder::delete($path);
                    }
                }
                //if($elementPath == 'media' && $destination) {
                //    JFolder::delete($source);
                //}
            }
        }
    }

    if(is_dir(JPATH_SITE.DS.'modules'.DS.$module)) {
        JFolder::delete(JPATH_SITE.DS.'modules'.DS.$module);
    }

    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_HIKASHOP_MAGICSLIDESHOW_UNINSTALL_TEXT').'</p>
          </div>';

    sendHikashopMagicslideshowModuleStat('uninstall');
    return true;
}

class com_hikashop_magicslideshowInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagicslideshowForHikashop();
    }

    function update($parent) {
        return installMagicslideshowForHikashop();
    }

    function uninstall($parent) {
        return uninstallMagicslideshowForHikashop();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendHikashopMagicslideshowModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.3.4' || 'working' == 'v3.2.12') {
        return;
    }
    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    $platformVersion = 'undefined';

    $database = JFactory::getDBO();
    //NOTICE: JDatabase::replacePrefix function does not replace prefix in quotes (' and ")
    $tablePrefix = $database->getPrefix();
    $query = "SHOW TABLES LIKE '{$tablePrefix}hikashop_config'";
    $database->setQuery($query);
    $table = $database->loadResult();
    if(!empty($table)) {
        $query = "SELECT `config_value` as `version` FROM `#__hikashop_config` WHERE config_namekey='version' LIMIT 1";
        $database->setQuery($query);
        $results = $database->loadObject();
        if(!empty($results)) {
            $platformVersion = $results->version;
        }
    }

    $path = "api/stat/?action={$action}&tool_name=magicslideshow&license=trial&tool_version=v3.2.12&module_version=v1.3.4&platform_name=hikashop&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}
