<?php

defined('_JEXEC') or die('Restricted access');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla view library
jimport('joomla.application.component.view');

if(!defined('MAGICTOOLBOX_LEGACY_VIEW_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_VIEW_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyView extends JViewLegacy {}
    } else {
        class MagicToolboxLegacyView extends JView {}
    }
}

class Hikashop_MagicslideshowViewDefault extends MagicToolboxLegacyView {

    function display($tpl = null) {

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $app->input->set('hidemainmenu' , true );
        } else {
            JRequest::setVar('hidemainmenu', true);
        }

        $document = JFactory::getDocument();
        $document->addStyleSheet(JURI::root().'media/com_hikashop_magicslideshow/backend.css');

        JToolBarHelper::title(JText::_('COM_HIKASHOP_MAGICSLIDESHOW_MANAGER_SETTINGS'), 'magicslideshow.png');
        JToolBarHelper::save('save');//Save & Close
        JToolBarHelper::apply('apply');//Save
        JToolBarHelper::cancel('cancel', 'Close');//Close

        require_once(JPATH_SITE.DS.'modules'.DS.'mod_hikashop_magicslideshow'.DS.'classes'.DS.'magicslideshow.module.core.class.php');
        $this->tool = new MagicSlideshowModuleCoreClass();
        $database = JFactory::getDBO();
        $database->setQuery("SELECT block, name, value FROM `#__hikashop_magicslideshow_config`");
        $results = $database->loadAssocList();
        if(!empty($results)) {
            foreach($results as $row) {
                $this->tool->params->setValue($row['name'], $row['value'], $row['block']);
            }
        }

        //NOTE: change subtype for some params to display them like radio
        foreach($this->tool->params->getParams() as $paramId => $param) {
           if($this->tool->params->getSubType($paramId) == 'select' && count($this->tool->params->getValues($paramId)) < 6)
               $this->tool->params->setSubType($paramId, 'radio');
        }

        $this->blocks = array('default' => 'Product page');
        $this->imageUrl = JURI::root().'media/com_hikashop_magicslideshow/images/';
        $this->paramsMap = array(
			'default' => array(
				'General' => array(
					'enable-effect',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'selector-max-width',
					'selector-max-height',
					'square-images',
				),
				'Common settings' => array(
					'width',
					'height',
					'orientation',
					'arrows',
					'loop',
					'effect',
					'effect-speed',
					'effect-easing',
				),
				'Autoplay' => array(
					'autoplay',
					'slide-duration',
					'shuffle',
					'kenburns',
					'pause',
				),
				'Selectors' => array(
					'selectors-style',
					'selectors',
					'selectors-eye',
					'bullets-preview',
					'selectors-fill',
				),
				'Caption' => array(
					'caption',
				),
				'Other settings' => array(
					'fullscreen',
					'preload',
					'keyboard',
					'show-loader',
				),
				'Miscellaneous' => array(
					'show-message',
					'message',
					'imagemagick',
					'image-quality',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
			),
		);

        parent::display($tpl);

    }


}
