<?php
/**
 * Magic Thumb Module
 *
 * @file AdminMagicThumb.inc (module admin panel)
 * @package MagicThumb
 * @author MagicToolbox <support@magictoolbox.com> <http://magictoolbox.com/>
 * @link http://magictoolbox.com/magicthumb/
 * @version v2.13.3 [v1.6.103:v3.0.20]
 */ 
class AdminMagicThumbController extends GalleryController {

    function handleRequest($form) {
        global $gallery;

        $ret = GalleryCoreApi::assertUserIsSiteAdministrator();
        if ($ret) return array($ret, null);

        $error = $status = array();
        if (isset($form['action']['save'])) {
            list($r,$tool) = GalleryCoreApi::loadPlugin('module','magicthumb',true);
            if($r) return array($r, null);

            foreach($tool->params->getParams() as $name => $value) {
                if(!$tool->isActived('thumbnail') && $name == 'use-thumbnails') continue;
                //if($form['pages']=='Item page'&&$name=='enable-effect-on-album-image') continue;
                //if($form['pages']=='Item page'&&$name=='show-link-to-photo-page') continue;
                //if($form['pages']=='Item page'&&$name=='link-to-photo-page-title') continue;
                //if($form['pages']=='Item page'&&$name=='link-to-album-page-title') continue;
                //if($form['show_message']=='No'&&$name=='message') continue;
                //if($form['show_link_to_photo_page']=='No'&&$name=='link-to-photo-page-title') continue;
                //if($form['show_link_to_photo_page']=='No'&&$name=='link-to-album-page-title') continue;
                //if($form['loading_animation']=='No'&&$name=='loading-animation-image') continue;
                //if($form['loading_animation']=='No'&&$name=='loading-animation-text') continue;
                if($value['type'] != 'text' && trim($form[$name]) == '') {
                    $error[] = "form[error][{$name}][missing]";
                } else {
                    $ret = GalleryCoreApi::setPluginParameter('module','magicthumb',$name,$form[$name]);
                    if ($ret) return array($ret, null);
                }
            }

    	    if (empty($error)) {
                GalleryCoreApi::setPluginParameter('module','magicthumb','is_configured','Yes');
                if ($ret) return array($ret, null);
                if(!$tool->isActived() && $form['activate_after_save'] == 'Yes') {
                    list ($ret) = $tool->activate();
                    if ($ret) return array($ret, null);
                } else {
                    list ($ret) = $tool->reactivate();
                    if ($ret) return array($ret, null);
                }
                
        		$redirect['view'] = 'core.SiteAdmin';
        		if ($tool->isActived()) {
        		    $redirect['subView'] = 'magicthumb.AdminMagicThumb';
        		    $status['saved'] = 1;
                    if(isset($form['activate_after_save'])&&$form['activate_after_save']=='Yes') $status['activated'] = 1;
        		} else {
        		    $redirect['subView'] = 'core.AdminPlugins';
        		    $status['configured'] = 'magicthumb';
        		}
            }

    	} else if (isset($form['action']['reset'])) {
    	    $redirect['view'] = 'core.SiteAdmin';
    	    $redirect['subView'] = 'magicthumb.AdminMagicThumb';
    	} else if (isset($form['action']['cancel'])) {
    	    $redirect['view'] = 'core.SiteAdmin';
    	    $redirect['subView'] = 'core.AdminPlugins';
    	}

        if (!empty($redirect)) {
            $results['redirect'] = $redirect;
        } else {
            $results['delegate']['view'] = 'core.SiteAdmin';
            $results['delegate']['subView'] = 'magicthumb.AdminMagicThumb';
        }
        
        $results['status'] = $status;
        $results['error'] = $error;

        return array(null, $results);
    }
    
}

class AdminMagicThumbView extends GalleryView {

    function loadTemplate(&$template, &$form) {
        global $gallery;
        
        $ret = GalleryCoreApi::assertUserIsSiteAdministrator();
        if($ret) return array($ret, null);

        list($r,$tool) = GalleryCoreApi::loadPlugin('module','magicthumb',true);
        if($r) return array($r, null);
        
        /* Load our default values if we didn't just come from this form. */
        if ($form['formName'] != 'AdminMagicThumb') {
            foreach($tool->params->getParams() as $name => $val) {
                $form[$name] = $tool->params->getValue($name);
            }
            $form['activate_after_save'] = 'Yes';
            $form['formName'] = 'AdminMagicThumb';
        }

        $form['show_activate_after_save'] = 'Yes';
        if($tool->isActived()) $form['show_activate_after_save'] = 'No';

        $form['show_thumbnail_question'] = 'Yes';
        if(!$tool->isActived('thumbnail')) $form['show_thumbnail_question'] = 'No';
        
        $form['show_warning'] = 'Yes';
        if($tool->check_writable()) $form['show_warning'] = 'No';
        
        //$template->javascript('modules/magicthumb/core/utils.js');
        
        $GLOBALS['magicthumb_admin_form'] = & $form;
        
        $template->setVariable('controller', 'magicthumb.AdminMagicThumb');
        return array(null, array('body' => 'modules/magicthumb/templates/AdminMagicThumb.tpl'));
    }
}
?>
